(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    323698,       6194]
NotebookOptionsPosition[    314694,       6048]
NotebookOutlinePosition[    315109,       6066]
CellTagsIndexPosition[    315066,       6063]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Package SetAxes",
 StyleBox["\n",
  FontSize->18],
 StyleBox["2-D plots in the traditional style\nVersion 1 (June, 2015)",
  FontSize->24]
}], "Title",
 CellChangeTimes->{{3.416793497321661*^9, 3.4167935231187553`*^9}, {
   3.4167935994084544`*^9, 3.416793629722043*^9}, {3.4167936800844607`*^9, 
   3.416793744707384*^9}, 3.416793813075693*^9, {3.4167938802422733`*^9, 
   3.416793898638726*^9}, {3.421163649893717*^9, 3.4211636584660435`*^9}, {
   3.427290640151464*^9, 3.4272906544319983`*^9}, {3.4272907190949793`*^9, 
   3.427290738522915*^9}, {3.427548943524763*^9, 3.427548944215757*^9}, {
   3.441217257775936*^9, 3.4412172657273693`*^9}, {3.4412173683349123`*^9, 
   3.4412173703578205`*^9}, {3.443483436270243*^9, 3.443483450690979*^9}, {
   3.4451845388931985`*^9, 3.445184546694416*^9}, {3.445252178509446*^9, 
   3.4452521793306274`*^9}, {3.4680693320942945`*^9, 
   3.4680693376880445`*^9}, {3.4737973510049644`*^9, 3.47379736070809*^9}, {
   3.473945784810568*^9, 3.473945785857443*^9}, {3.475665461123702*^9, 
   3.47566546751289*^9}, {3.4757683770424995`*^9, 3.4757683779337807`*^9}, {
   3.4764975027188497`*^9, 3.4764975031895266`*^9}, {3.476532767439221*^9, 
   3.476532768070128*^9}, 3.476620963902355*^9, {3.4768252749099855`*^9, 
   3.476825286056012*^9}, {3.4770781916919184`*^9, 3.47707819224271*^9}, {
   3.477167690311277*^9, 3.477167690892112*^9}, {3.4776543687827744`*^9, 
   3.4776543697842145`*^9}, {3.4828644775466337`*^9, 
   3.4828644822333727`*^9}, {3.504469029781717*^9, 3.504469050741856*^9}, {
   3.5124002734394064`*^9, 3.51240027888724*^9}, {3.518724960705042*^9, 
   3.5187249656120977`*^9}, {3.5196346056426673`*^9, 
   3.5196346071748705`*^9}, {3.529843747391565*^9, 3.5298437587979665`*^9}, {
   3.5300530170447936`*^9, 3.5300530180562477`*^9}, {3.53005335734412*^9, 
   3.5300533597375617`*^9}, {3.5304611779778447`*^9, 3.530461178438507*^9}, {
   3.53108363488043*^9, 3.531083645105133*^9}, {3.53125099379364*^9, 
   3.5312509951355696`*^9}, {3.5325642612057133`*^9, 3.532564266423216*^9}, {
   3.536248736803029*^9, 3.536248758884781*^9}, {3.537825867455474*^9, 
   3.5378258770893264`*^9}, {3.5380067195148945`*^9, 
   3.5380067217180624`*^9}, {3.53814098707555*^9, 3.5381409878066015`*^9}, {
   3.539208074604491*^9, 3.5392080765372705`*^9}, {3.540822028783059*^9, 
   3.5408220334397554`*^9}, {3.550149075607053*^9, 3.5501490812551746`*^9}, {
   3.579013143917255*^9, 3.579013248327841*^9}, {3.5890196382920017`*^9, 
   3.5890196483691463`*^9}, {3.5891027609203663`*^9, 3.589102761421487*^9}, {
   3.590757463467696*^9, 3.590757464049868*^9}, 3.590854257845747*^9, {
   3.5988954125450087`*^9, 3.598895416898739*^9}, {3.6083854090404997`*^9, 
   3.6083854097196283`*^9}, {3.617461656465294*^9, 3.617461657311667*^9}, {
   3.6393014446534147`*^9, 3.639301504835723*^9}, {3.639301537491768*^9, 
   3.639301557267632*^9}, {3.6393016447330008`*^9, 3.639301647603623*^9}, {
   3.639301897739771*^9, 3.6393018983076153`*^9}, {3.639303062323909*^9, 
   3.6393031006917553`*^9}, 3.639303132901108*^9, 3.639303171587636*^9, {
   3.6415592205329733`*^9, 3.641559220735546*^9}, {3.642343448777638*^9, 
   3.642343449753469*^9}},
 TextAlignment->Center],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellChangeTimes->{{3.579014381171195*^9, 3.579014388222763*^9}, {
  3.579014422177668*^9, 3.579014424244499*^9}}],

Cell[TextData[{
 StyleBox["SetAxes is a package for formatting 2-D plots with linear and/or \
(common) log axes.  It is meant to be utilitarian, not fancy, simply an \
interactive tool to facilitate the generation of publication-quality plots in \
the traditional style: tick marks drawn to the ",
  FontFamily->"Arial",
  FontSize->16],
 StyleBox["outside",
  FontFamily->"Arial",
  FontSize->16,
  FontSlant->"Italic"],
 StyleBox[" of the plot with numeric labels.  The abscissa and ordinate are \
formatted separately giving linear, log or semi-log plots.\n\nPlot functions \
directly affected include\n\tPlot[], DiscretePlot[], LogPlot[], \
LogLinearPlot[], LogLogPlot[]\nand their List",
  FontFamily->"Arial",
  FontSize->16],
 "\[Ellipsis]",
 StyleBox[" variants\n\tListPlot[], ListLogPlot[], ListLogLinearPlot[], \
ListLogLogPlot[].\nHowever, other kinds of plots (e.g., histograms) can be \
formatted using an invisible \[OpenCurlyDoubleQuote]fakePlot\
\[CloseCurlyDoubleQuote] plus the Show[] function (see below).",
  FontFamily->"Arial",
  FontSize->16]
}], "Text",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4272217582198*^9, 3.4272218728245935`*^9}, {
   3.427290811658078*^9, 3.4272908999850864`*^9}, {3.4272909345848384`*^9, 
   3.4272912246819773`*^9}, {3.4272912743033295`*^9, 
   3.4272915489682784`*^9}, {3.427310006028227*^9, 3.4273100097836275`*^9}, {
   3.579013306400366*^9, 3.579013463114151*^9}, {3.57901349600138*^9, 
   3.579013535288192*^9}, {3.579013597207302*^9, 3.579013608726171*^9}, {
   3.579013964315936*^9, 3.579014067149221*^9}, {3.5790141386879473`*^9, 
   3.579014141328045*^9}, {3.579014321635317*^9, 3.579014339778817*^9}, {
   3.579364589658305*^9, 3.5793646033136883`*^9}, {3.589019663440826*^9, 
   3.589019760736966*^9}, 3.5890198613910637`*^9, {3.589040104503469*^9, 
   3.589040105125814*^9}, {3.590757493656825*^9, 3.59075754095161*^9}, {
   3.590852658444201*^9, 3.5908526805471687`*^9}, {3.5915222227735567`*^9, 
   3.591522591836556*^9}, {3.591522624580476*^9, 3.591522646868688*^9}, {
   3.591522690270341*^9, 3.591522696857201*^9}, {3.591522734188455*^9, 
   3.5915227416285143`*^9}, {3.591522789348473*^9, 3.591522890860601*^9}, {
   3.591522927142809*^9, 3.591522943068982*^9}, {3.5915229950389853`*^9, 
   3.591522995324699*^9}, {3.5988958386967363`*^9, 3.59889584205048*^9}, 
   3.598895994360586*^9, {3.6393016127890882`*^9, 3.6393016152036047`*^9}, {
   3.639301827468601*^9, 3.6393019379075413`*^9}, {3.639301974747591*^9, 
   3.639302367531602*^9}, {3.63930244792528*^9, 3.639302521267647*^9}, {
   3.639302690908559*^9, 3.639302693539604*^9}, {3.639302734604622*^9, 
   3.63930282392379*^9}, {3.6393028718925247`*^9, 3.639302889651621*^9}, {
   3.6393029332525053`*^9, 3.639303012307798*^9}, {3.639303215723835*^9, 
   3.639303258099736*^9}, {3.639303289459717*^9, 3.63930338177184*^9}, {
   3.6393034544281473`*^9, 3.639303469131871*^9}, 3.6393036291573877`*^9, {
   3.639303675965129*^9, 3.639303682747758*^9}, {3.639303721477215*^9, 
   3.639303750843925*^9}, {3.63930479258427*^9, 3.639304821935182*^9}, 
   3.63930486140903*^9, {3.639838825383998*^9, 3.6398388626169558`*^9}, {
   3.639838893719884*^9, 3.639838971077552*^9}, {3.639839135449843*^9, 
   3.639839201142315*^9}, {3.639839291245123*^9, 3.6398393077386713`*^9}, {
   3.639839383922104*^9, 3.639839385712346*^9}, {3.6398394554081707`*^9, 
   3.6398394579019623`*^9}, {3.641559277715425*^9, 3.64155927790207*^9}, {
   3.705148614991352*^9, 3.705148639522787*^9}},
 FontSize->24,
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"969219f9-5275-4a3b-917f-a966d7b45a2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Available Functions", "Section",
 CellChangeTimes->{{3.579014435600346*^9, 3.5790144423552837`*^9}, {
  3.63930159181301*^9, 3.63930159709956*^9}}],

Cell[TextData[{
 "SetAxes provides three functions: setLinAxis[], setLogAxis[] and \
defaultAxes[], as follows:\n\nsetLinAxis[\n\tisAbscissa (True/False)\n\taxis \
label\n\tlower bound\n\tupper bound\n\t# of major ticks, including ends\n\t# \
of minor ticks between major ticks\n\t{# of digits in tick label, # of \
decimal places in the latter}]\t\nsetLogAxis[\n\tisAbscissa (True/False)\n\t\
axis label\n\tlower bound ((int) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["log", "10"], TraditionalForm]]],
 ")\n\tupper bound ((int) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["log", "10"], TraditionalForm]]],
 ")\n\t# of minor ticks between major ticks (0, 1, 4 or 8)]\t\ndefaultAxes[]"
}], "Text",
 CellChangeTimes->{{3.639305021303783*^9, 3.6393051019109507`*^9}, {
  3.639305156999761*^9, 3.639305241383005*^9}, {3.6393052980878267`*^9, 
  3.639305362959074*^9}, {3.6393054706558247`*^9, 3.639305482657168*^9}, {
  3.639305596599774*^9, 3.639305652481779*^9}, {3.6413048187300863`*^9, 
  3.641304819487966*^9}, {3.6413065817085333`*^9, 3.64130658281885*^9}, {
  3.641306627986637*^9, 3.641306661920528*^9}, {3.6413067166240187`*^9, 
  3.641306737670205*^9}, {3.641306806829831*^9, 3.6413068140758343`*^9}, {
  3.641306886971422*^9, 3.641306890521731*^9}, {3.641306979448707*^9, 
  3.641306979590942*^9}, {3.6413084711157007`*^9, 3.641308473017754*^9}, {
  3.684516715003901*^9, 3.6845167158944607`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example #1 (linear axes)", "Section",
 CellChangeTimes->{{3.579014435600346*^9, 3.5790144423552837`*^9}, {
  3.63930159181301*^9, 3.63930159709956*^9}, {3.639305743544083*^9, 
  3.639305760646989*^9}}],

Cell["Load the package", "Text",
 CellChangeTimes->{{3.6393066735674477`*^9, 3.639306676286769*^9}},
 FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
 RowBox[{"<<", "\"\<SetAxes.m\>\"", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"in", " ", "~"}], "/", "Library"}], "/", "Mathematica"}], "/", 
     "Applications"}], " ", "or", " ", "equivalent"}], " ", "*)"}]}]], "Input",\

 CellChangeTimes->{{3.3903137280593367`*^9, 3.390313747222797*^9}, {
   3.4113158718357697`*^9, 3.4113159185867777`*^9}, {3.411316627871656*^9, 
   3.4113166540621567`*^9}, {3.4306721520802593`*^9, 3.430672157980373*^9}, {
   3.430672985394733*^9, 3.430672987481298*^9}, {3.4307394854302397`*^9, 
   3.430739485491235*^9}, {3.44076619966846*^9, 3.4407661997184896`*^9}, {
   3.459617787231657*^9, 3.459617787289818*^9}, {3.490957464908905*^9, 
   3.490957464963758*^9}, {3.50125455961086*^9, 3.501254559659027*^9}, {
   3.529943411613174*^9, 3.5299434121221247`*^9}, {3.632735514434368*^9, 
   3.632735516430337*^9}, 3.641305603529825*^9, 3.641396397876968*^9, {
   3.6415592491327763`*^9, 3.6415592496073103`*^9}, {3.64155937238054*^9, 
   3.641559375835239*^9}, 3.64156030655274*^9, 3.6415603394508457`*^9, 
   3.641560609119752*^9},ExpressionUUID->"d6a84bf2-782c-4ec9-861b-\
58b6d5e2c5a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"func1", " ", "=", " ", 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.639306267150528*^9, 
  3.639306317631262*^9}},ExpressionUUID->"c5feabd4-5ba0-4e12-bd20-\
4a53de61c613"],

Cell[TextData[{
 "The recommended procedure is to plot the desired function ",
 StyleBox["without",
  FontSlant->"Italic"],
 " setAxes, in order to see what will look good, then call two formatting \
functions accordingly."
}], "Text",
 CellChangeTimes->{{3.639306327191049*^9, 3.639306406718934*^9}, {
   3.639840576732823*^9, 3.639840582138801*^9}, 3.641560741730605*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"func1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.639306444310156*^9, 3.639306476559431*^9}, {
  3.639935773965146*^9, 
  3.6399357765712843`*^9}},ExpressionUUID->"d154abff-d074-4dbb-8d86-\
3926c7a8343e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu7bqXe6UUJVsoW5GlEJ8hFVlC9j1liRIVQtlClsTXFkLZ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       "]]},
     Annotation[#, "Charting`Private`Tag$1196#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.639306478665008*^9, 3.639307281552868*^9, 3.639307388466367*^9, 
   3.6398398015985317`*^9, 3.63984000097783*^9, 3.6398447415765247`*^9, 
   3.639935783100124*^9, 3.639935952850465*^9, {3.639936749321875*^9, 
   3.639936773786476*^9}, 3.639937106192935*^9, 3.6404346688466787`*^9, 
   3.6413056309092007`*^9, 3.641306007534576*^9, 3.6413061564289427`*^9, 
   3.6413062964297457`*^9, 3.6413071319469633`*^9, 3.641307722086924*^9, 
   3.6413078730511847`*^9, 3.641308215527562*^9, 3.641308248877985*^9, 
   3.64130839827707*^9, 3.641393254741901*^9, 3.641393448869068*^9, 
   3.64139365094921*^9, 3.6413936938525333`*^9, 3.641396403435721*^9, 
   3.6413965297023907`*^9, 3.6413974690087757`*^9, {3.641397615054481*^9, 
   3.641397628512549*^9}, 3.641471681991929*^9, 3.6414719884538183`*^9, 
   3.6414722195159187`*^9, 3.641472735015465*^9, 3.641474611194035*^9, 
   3.641474921828864*^9, 3.641474968166668*^9, 3.641475233358844*^9, 
   3.6414757693020363`*^9, 3.641475807732626*^9, 3.641476257258318*^9, 
   3.641476549437415*^9, 3.64147691101607*^9, 3.641477020570362*^9, 
   3.641559233179328*^9, 3.641559346679492*^9, 3.641560146679229*^9, 
   3.641560311833433*^9, 3.6415605261400623`*^9, 3.641560683041525*^9, 
   3.642343419563397*^9, 3.6423439214736643`*^9, 3.683045513933611*^9, 
   3.6833920774466867`*^9, 3.683392212217988*^9, 3.683393178228025*^9, 
   3.684518428606163*^9, 3.705148496427236*^9, 3.731850610447405*^9, 
   3.731851894128963*^9, 
   3.731852215426997*^9},ExpressionUUID->"598f6a00-497b-4032-bce8-\
a6468b692d3f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"setLinAxis", "[", 
   RowBox[{"True", ",", "\"\<z\>\"", ",", 
    RowBox[{"-", "4"}], ",", "4", ",", "5", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"setLinAxis", "[", 
   RowBox[{
   "False", ",", "\"\<Standard Gaussian PDF\>\"", ",", "0", ",", "0.4", ",", 
    "5", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.39016221101334*^9, 3.390162211392661*^9}, {
   3.390162245676605*^9, 3.390162245789352*^9}, {3.390163923983576*^9, 
   3.390163931457799*^9}, {3.390303264120278*^9, 3.390303274956976*^9}, {
   3.390303362119499*^9, 3.390303383619132*^9}, {3.390303466907736*^9, 
   3.3903034802283382`*^9}, 3.3903131134052477`*^9, {3.46427643575497*^9, 
   3.464276455200439*^9}, {3.46434289703349*^9, 3.46434290145258*^9}, {
   3.529227331346245*^9, 3.529227334242074*^9}, {3.529228361953331*^9, 
   3.529228363655961*^9}, 3.529228411057817*^9, {3.529859047367486*^9, 
   3.529859094782133*^9}, {3.556531771462447*^9, 3.556531842661377*^9}, {
   3.556531926766034*^9, 3.556531942589464*^9}, {3.556532183974278*^9, 
   3.55653219610211*^9}, {3.5565326016864347`*^9, 3.5565326043097754`*^9}, {
   3.5565456982412653`*^9, 3.556545701887532*^9}, {3.557142836011086*^9, 
   3.557142907168467*^9}, {3.557143272994123*^9, 3.5571433176156282`*^9}, {
   3.557143431088841*^9, 3.557143453376718*^9}, 3.557143544242992*^9, {
   3.5571585775971518`*^9, 3.557158588475452*^9}, 3.557223949427227*^9, {
   3.583505138762953*^9, 3.583505187077249*^9}, {3.5835054155311003`*^9, 
   3.583505437770534*^9}, {3.583580794585649*^9, 3.58358079465945*^9}, {
   3.604843540167177*^9, 3.604843668869877*^9}, {3.604843933326126*^9, 
   3.6048439343337603`*^9}, {3.632735782455123*^9, 3.632735790942565*^9}, {
   3.632735871322358*^9, 3.6327358742342052`*^9}, {3.632735920503312*^9, 
   3.632735927838423*^9}, {3.632736217750588*^9, 3.632736223814178*^9}, {
   3.632736268882636*^9, 3.632736309094421*^9}, {3.632736893057959*^9, 
   3.632736906999136*^9}, {3.632738804123653*^9, 3.632738834232999*^9}, {
   3.639306831360304*^9, 3.639306929887392*^9}, 3.6393075355610943`*^9, {
   3.6393078251958523`*^9, 3.6393078286555033`*^9}, {3.6399357906749163`*^9, 
   3.639935800474896*^9}, {3.6833920642569513`*^9, 3.683392069120576*^9}, 
   3.6833931698131113`*^9},ExpressionUUID->"fea26e8e-96c2-4af4-b718-\
a515b604a8f2"],

Cell["\<\
Plot again, specifying the PlotRange.  PlotTheme \
\[OpenCurlyDoubleQuote]Classic\[CloseCurlyDoubleQuote] gives narrower curves.\
\
\>", "Text",
 CellChangeTimes->{{3.639307466471797*^9, 3.6393074760470123`*^9}, {
  3.639839752102476*^9, 3.639839770204191*^9}, {3.639839836362241*^9, 
  3.639839857817481*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"func1", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.4"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6393069416894093`*^9, 3.639306962056123*^9}, {
   3.639307252682598*^9, 3.639307261703432*^9}, {3.639307349351437*^9, 
   3.63930736329531*^9}, {3.639307399610671*^9, 3.6393074024076567`*^9}, {
   3.6393078358670273`*^9, 3.6393078358874187`*^9}, {3.639839777044681*^9, 
   3.639839788428226*^9}, 3.6398399844220343`*^9, {3.6399358218714857`*^9, 
   3.639935824202023*^9}, {3.642343407044631*^9, 
   3.642343409275334*^9}},ExpressionUUID->"f4bfa27e-5112-4008-a227-\
01d60b38771d"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu7bqXe6UUJVsoW5GlEJ8hFVlC9j1liRIVQtlClsTXFkLZ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       "]]},
     Annotation[#, "Charting`Private`Tag$1356#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Standard Gaussian PDF\"", FontFamily -> "Helvetica", FontSize -> 12, 
       FontWeight -> "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"z\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}}, {{{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}, {{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4, 4}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.6393069738390493`*^9, 3.639307290931745*^9, 3.6393073654737473`*^9, 
   3.639307410135446*^9, 3.639307542627091*^9, 3.639307837779291*^9, {
   3.639839791237401*^9, 3.639839801663344*^9}, 3.6398400010614758`*^9, 
   3.639844741656598*^9, {3.639935809085526*^9, 3.639935824987463*^9}, 
   3.639935952949054*^9, {3.639936749397092*^9, 3.639936773859455*^9}, 
   3.6399371062673903`*^9, 3.640434668938045*^9, 3.641305630995916*^9, 
   3.64130600767749*^9, 3.641306156561578*^9, 3.641306296509017*^9, 
   3.641307132014255*^9, 3.6413077221643667`*^9, 3.641307873124633*^9, 
   3.641308215608554*^9, 3.641308248953742*^9, 3.641308398380067*^9, 
   3.641393254828843*^9, 3.641393448960689*^9, 3.6413936510568123`*^9, 
   3.641393693972352*^9, 3.6413964034886627`*^9, 3.641396529778616*^9, 
   3.641397469055086*^9, {3.6413976151658278`*^9, 3.6413976286083393`*^9}, 
   3.6414716820895643`*^9, 3.641471988577849*^9, 3.641472219586083*^9, 
   3.64147273513307*^9, 3.641474611331402*^9, 3.6414749219238586`*^9, 
   3.641474968262146*^9, 3.641475233425626*^9, 3.6414757693775177`*^9, 
   3.641475807855196*^9, 3.641476257333304*^9, 3.6414765495642443`*^9, 
   3.641476911165402*^9, 3.641477020646666*^9, 3.6415592333113527`*^9, 
   3.6415593468039618`*^9, 3.641560146781659*^9, 3.641560311900608*^9, 
   3.641560526302478*^9, 3.641560683182745*^9, 3.6423434196983967`*^9, 
   3.6423439216061287`*^9, 3.683045514213081*^9, 3.683392077717313*^9, 
   3.683392212346946*^9, 3.68339317835355*^9, 3.684518428957102*^9, 
   3.705148496619155*^9, 3.7318506105941973`*^9, 3.7318518942433243`*^9, 
   3.731852215637929*^9},ExpressionUUID->"2d4853e6-1520-4596-9578-\
2931d22d8e42"]
}, Open  ]],

Cell["", "PageBreak",
 PageBreakBelow->True],

Cell["\<\
As sometimes happens, a terminal tick mark did not show.  The solution is to \
add a tiny delta to the affected axis range.\
\>", "Text",
 CellChangeTimes->{{3.639306993022896*^9, 3.639307054982851*^9}, {
  3.639307154527051*^9, 3.639307156982914*^9}, {3.639839685232542*^9, 
  3.6398396868387814`*^9}},
 FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"func1", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.4000001"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "1"}], ",", 
    RowBox[{"ImageSize", "->", " ", "600"}], ",", 
    RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6393069416894093`*^9, 3.639306962056123*^9}, {
   3.639307064712349*^9, 3.639307117231448*^9}, {3.639307308931258*^9, 
   3.639307315243002*^9}, {3.639307616249954*^9, 3.639307624019699*^9}, {
   3.639307845555668*^9, 3.639307845607396*^9}, 3.6398398235978127`*^9, {
   3.639839990060237*^9, 3.6398400076384687`*^9}, {3.639935834630796*^9, 
   3.6399358436571617`*^9}, {3.731851850749549*^9, 
   3.731851866268827*^9}},ExpressionUUID->"195f31c6-e896-45f9-9ecc-\
6d5bda8b9685"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu7bqXe6UUJVsoW5GlEJ8hFVlC9j1liRIVQtlClsTXFkLZ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       "]]},
     Annotation[#, "Charting`Private`Tag$1556#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Standard Gaussian PDF\"", FontFamily -> "Helvetica", FontSize -> 12, 
       FontWeight -> "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"z\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}}, {{{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}, {{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImageMargins->1,
  ImagePadding->All,
  ImageSize->600,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4, 4}, {0, 0.4000001}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.6393071087756233`*^9, 3.6393071197147713`*^9}, 
   3.639307426472267*^9, 3.6393075483935003`*^9, 3.639307624981759*^9, 
   3.639307848231297*^9, {3.639839801718659*^9, 3.639839826511877*^9}, {
   3.63984000121621*^9, 3.6398400089279013`*^9}, 3.639844741728178*^9, 
   3.6399358443206*^9, 3.639935953016897*^9, {3.6399367494623537`*^9, 
   3.639936773921373*^9}, 3.6399371063208923`*^9, 3.640434669007703*^9, 
   3.641305631045154*^9, 3.641306007743836*^9, 3.6413061566299057`*^9, 
   3.64130629662289*^9, 3.641307132073968*^9, 3.641307722224613*^9, 
   3.6413078731873827`*^9, 3.64130821567412*^9, 3.641308249122027*^9, 
   3.641308398443527*^9, 3.641393254907887*^9, 3.641393449015932*^9, 
   3.64139365115366*^9, 3.641393694037463*^9, 3.64139640351935*^9, 
   3.64139762866973*^9, 3.6414716821398487`*^9, 3.641471988674618*^9, 
   3.641472219652319*^9, 3.641472735194643*^9, 3.6414746114395514`*^9, 
   3.641474921988926*^9, 3.6414749684444647`*^9, 3.641475233475108*^9, 
   3.641475769480955*^9, 3.641475807919097*^9, 3.641476257443145*^9, 
   3.6414765496292477`*^9, 3.64147691123197*^9, 3.641477020764543*^9, 
   3.641559233371665*^9, 3.641559346859332*^9, 3.641560146849238*^9, 
   3.6415603119494*^9, 3.641560526351609*^9, 3.641560683314949*^9, 
   3.642343605881465*^9, 3.642343921667926*^9, 3.683045514294312*^9, 
   3.683392077795329*^9, 3.683392212434712*^9, 3.683393178430708*^9, 
   3.68451842903485*^9, 3.705148496724955*^9, 3.731850610686531*^9, {
   3.7318518700229807`*^9, 3.731851894345942*^9}, 
   3.7318522157570066`*^9},ExpressionUUID->"35dca69f-2b8f-4894-9165-\
2edfbd9b81f2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.641476072670474*^9, 
  3.641476128676297*^9}},ExpressionUUID->"134fd2fb-8ba4-4e1a-b415-\
e8971692fe3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<plot1.png\>\"", ",", "plot1"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
  3.63984107879326*^9, 3.6398411135145807`*^9}, {3.6415601085408792`*^9, 
  3.6415601101958237`*^9}, {3.683045474450841*^9, 3.6830454759058332`*^9}, {
  3.683392015226873*^9, 3.683392019696908*^9}, {3.731850621541295*^9, 
  3.73185062221975*^9}},ExpressionUUID->"873ee5e9-2aa4-4b73-b0a8-\
ddfa6c71cc7a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<plot1.pdf\>\"", ",", "plot1"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
  3.63984107879326*^9, 3.6398411135145807`*^9}, {3.6415601085408792`*^9, 
  3.6415601101958237`*^9}, {3.683045474450841*^9, 3.6830454759058332`*^9}, {
  3.683392015226873*^9, 
  3.683392019696908*^9}},ExpressionUUID->"cd33bb7e-665b-4f1c-a924-\
493139e9d529"],

Cell["\<\
Styling options can be added if desired.  It is best to add a small image \
margin to prevent cropping.  Specifying the size desired in the final \
document is also a good idea, especially with PNG (bitmapped) output.\
\>", "Text",
 CellChangeTimes->{{3.639840181104141*^9, 3.639840194702861*^9}, {
  3.639840973087461*^9, 3.6398410307168303`*^9}, {3.6398412372872543`*^9, 
  3.639841271869235*^9}, {3.63993651707765*^9, 3.639936518707828*^9}, {
  3.642343525849025*^9, 3.6423435581342163`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"func1", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.4000001"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Dashed"}], "}"}]}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6393069416894093`*^9, 3.639306962056123*^9}, {
   3.639307064712349*^9, 3.639307117231448*^9}, {3.639307308931258*^9, 
   3.639307315243002*^9}, {3.639307616249954*^9, 3.639307624019699*^9}, {
   3.639307845555668*^9, 3.639307845607396*^9}, 3.6398398235978127`*^9, {
   3.639839990060237*^9, 3.6398400076384687`*^9}, {3.639840208260787*^9, 
   3.639840275093957*^9}, 3.639840786625072*^9, {3.639841045247744*^9, 
   3.63984105448214*^9}, {3.6399359057654552`*^9, 
   3.639935929766807*^9}},ExpressionUUID->"9eee9bae-41aa-4ddc-bbd1-\
3e0e810fb2fd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu7bqXe6UUJVsoW5GlEJ8hFVlC9j1liRIVQtlClsTXFkLZ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       "]]},
     Annotation[#, "Charting`Private`Tag$3104#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Standard Gaussian PDF\"", FontFamily -> "Helvetica", FontSize -> 12, 
       FontWeight -> "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"z\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}}, {{{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}, {{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImageMargins->1,
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4, 4}, {0, 0.4000001}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.6398402774044943`*^9, 3.63984080451467*^9, 3.639841057139443*^9, 
   3.639844741952716*^9, 3.639935953077444*^9, {3.6399367496656017`*^9, 
   3.639936773992063*^9}, 3.639937106375779*^9, 3.6404346691102552`*^9, 
   3.641305631094776*^9, 3.641306007810258*^9, 3.641306156700304*^9, 
   3.641306296690812*^9, 3.641307132138589*^9, 3.6413077224164953`*^9, 
   3.641307873243354*^9, 3.641308215734103*^9, 3.641308249231312*^9, 
   3.641308398548827*^9, 3.641393255021928*^9, 3.641393449082356*^9, 
   3.641393651238762*^9, 3.6413936941079493`*^9, 3.6413964035524178`*^9, 
   3.6413976287251663`*^9, 3.64147168219162*^9, 3.641471988735886*^9, 
   3.641472219831459*^9, 3.6414727352615843`*^9, 3.641474611505662*^9, 
   3.641474922053042*^9, 3.641474968513789*^9, 3.641475233525618*^9, 
   3.6414757695479307`*^9, 3.641475807986925*^9, 3.641476257510652*^9, 
   3.641476549739812*^9, 3.641476911336109*^9, 3.641477020835483*^9, 
   3.641559233426818*^9, 3.641559346914316*^9, 3.641560146916203*^9, 
   3.641560311998589*^9, 3.641560526401525*^9, 3.64156068338416*^9, 
   3.6423436089609127`*^9, 3.642343921725438*^9, 3.6830455143783083`*^9, 
   3.683392079237392*^9, 3.68339221297054*^9, 3.683393179372367*^9, 
   3.68451843025034*^9, 3.705148498279163*^9, 
   3.731852218367847*^9},ExpressionUUID->"5c3e8661-c536-4bff-a1e0-\
e6bda55a5d23"]
}, Open  ]],

Cell[TextData[{
 "Save plots in the local directory.  Any plot is best saved using Export[], ",
 StyleBox["not",
  FontColor->RGBColor[1, 0, 0]],
 " Save Selection As ..."
}], "Text",
 CellChangeTimes->{{3.641476043630189*^9, 3.641476051845183*^9}, {
  3.641476323973854*^9, 3.641476324180891*^9}, {3.64156001895322*^9, 
  3.6415600235672703`*^9}, {3.641560096126007*^9, 3.641560096854224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<plot2.pdf\>\"", ",", "plot2"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
  3.63984107879326*^9, 3.6398411135145807`*^9}, {3.6415601085408792`*^9, 
  3.6415601101958237`*^9}, {3.683045474450841*^9, 
  3.6830454759058332`*^9}},ExpressionUUID->"a493874e-7df2-44ee-b9cc-\
777141436b75"],

Cell["", "PageBreak",
 PageBreakBelow->True],

Cell["\<\
Axis formatting effected through SetAxes[] can be overridden in individual \
plots, e.g.,\
\>", "Text",
 CellChangeTimes->{{3.641471735208387*^9, 3.641471781605729*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"func1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.4000001"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<X\>\"", ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<PDF\>\"", ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}]}], "]"}]}], 
     "}"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.6414718264538107`*^9, 3.641471828446227*^9}, {
  3.641471866594016*^9, 3.641471891075066*^9}, {3.6414720881673183`*^9, 
  3.641472092273651*^9}, {3.641472173812811*^9, 
  3.6414721966155033`*^9}},ExpressionUUID->"11ec2f85-b407-416d-9cce-\
060231cd8269"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu7bqXe6UUJVsoW5GlEJ8hFVlC9j1liRIVQtlClsTXFkLZ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       "]]},
     Annotation[#, "Charting`Private`Tag$3489#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox["\"PDF\"", FontWeight -> "Plain", StripOnInput -> False], 
      TraditionalForm], None}, {
     FormBox[
      StyleBox["\"X\"", FontWeight -> "Plain", StripOnInput -> False], 
      TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}}, {{{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}, {{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4, 4}, {0, 0.4000001}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.641471893588971*^9, 3.641471989168428*^9, 
  3.641472220249275*^9, 3.641472735645875*^9, 3.6414746119251013`*^9, 
  3.641474922448954*^9, 3.641474968889556*^9, 3.641475233995977*^9, 
  3.641475769895359*^9, 3.641475808317391*^9, 3.641476257858356*^9, 
  3.641476550080443*^9, 3.641476911710476*^9, 3.641477021221143*^9, 
  3.64155923388568*^9, 3.641559347379046*^9, 3.641560147251685*^9, 
  3.641560312258339*^9, 3.641560526860434*^9, 3.641560683798438*^9, 
  3.6423439226314707`*^9, 3.683045515561496*^9, 3.683392079571342*^9, 
  3.683392213313805*^9, 3.68339317966879*^9, 3.684518430560903*^9, 
  3.705148498715014*^9, 
  3.731852218823998*^9},ExpressionUUID->"8131f0f4-0e36-4c0c-bd29-\
ef3bb129051e"]
}, Open  ]],

Cell["\<\
Default formatting can be restored using defaultAxes[].  This affects both \
axes.
Note: A more robust way to restore defaults is to Quit Kernel and start over.\
\
\>", "Text",
 CellChangeTimes->{{3.641307441937686*^9, 3.641307478959682*^9}, {
  3.641307530766232*^9, 3.641307536397979*^9}, {3.642347490557373*^9, 
  3.642347530918412*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"defaultAxes", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.641307483340053*^9, 
  3.641307487888751*^9}},ExpressionUUID->"447a95c4-14ed-4003-8df2-\
fbbf5abcc584"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"func1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.641307513077244*^9, 
  3.641307517845158*^9}},ExpressionUUID->"7d50f42f-8ce6-44c8-b747-\
3dea1f8bc5a1"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu7bqXe6UUJVsoW5GlEJ8hFVlC9j1liRIVQtlClsTXFkLZ
dxEhyUy2ZM9277VvlRQpKkvxu79zfr9/Zs7rnJkz8zzP+zPPM+c8wo43jJ1w
DAwMUvTD/56Pwt7FnR0y9kTqZ05atDDc2DgUubFJxqo6DkhN1wpDZbWc+Oov
MrbXNcgpbk4Yjh/Rd/z0lYz1PrAPl1IXgRO7wka7KWRsf1Lz3K11EUDmfnSm
PSdjp+rxT/eGikJI5o5rYgkZm7k17Gb+UhSazTnZYvPJmAV7JifXF1HQ6j5y
OvgJGTu4fnbum5EY6Ly0f+38gIy9D46M8ZIQB+MHPaXy9mTsOhPeIHHlMCRq
jOnIWJGxWLuSf71SR2Boa+GzuCkZ27Xb5EmiyxEw82QW3a9Lxgbu1hxrnD4C
1paqGQwnyJh22WvBUpoEXJEqfthDImP3nv8JJ3yWAt++sOsuTSSsdrNf0eCU
LDz86kNZqydhopxcL7edZSGH7apGaDUJ+6bg3rovQRa6QZ8ns4iE7QwlwIMv
siBSyfNmIIGEEU3zWrwz5aA3voBD3YWEtZvcILvul4f5slSfrksk7M+Pcxm7
9eRhoyN62sKGhOVwf9Y6ESgPoow3am4ZkbDxzXGur3Py4O91wqZYlYTJbA3y
ibxUAHHjjtI9XCRM97HSBnZDCU55NPDkEEjYESZN6RvFSmAUXRZ0jIWETcfG
EQvnlOBuc/zF85ucmHftRGC95QkYOG65FTTPiekNnIm4r3cS7u1ePP+1nhNb
fsHC262vAkNDxMW3lzixCPfrPxU61CHkysumUhtO7GLJ+NAVLoCja3aJyeac
mHC9gImcJUDk7henrupzYpVcTZt53wDUjC3iuJQ5MTYm/ocPYxEo6MtTsOfi
xB7aiYUUdGnARXsDdh0iJ3ZM+Grf0poGMHz/M3GclRPDVVyJjhXQBCuS7gPW
vxxY1gWdNepNTSDr/6CVf+bADjLHPn4heBrudKoF/W3iwNTMHKY5YrRAzOrz
xU+vOLBDmmm1Mg1aMPAl/kh/DQdmnXRf6cUXLZBmn/+QW8KBVR6Tk/6icwZm
zkWL6qZwYFYK+xlFyWfhfNvI+7TrHFhx1r9Nv/JzcBC7secEPwfm+MRvryHo
Qje34m2VfRzYBQUZP5UAXfB32hxU4+bAZN4JUTLrdGGEEJ6ohefA9hP/rAzI
6UG8aTq38RoRa2f6PEaS1gemr61c17uJ2O5ctl+JJy/AC7VoT893RKxOHQvy
vXsBHOIv9N9qJmJ2PWvGs9gFaFQcjfOvJ2JybEhXkZgh+AR/J0XmEbHqlqFM
i2pD+MKznzP3LhGL09wddnjcCFJdp64V+BIxD4N9obE4Yzj7Oq+7+CYRExdu
3FGXMIYch2MPK12JWDb6IjrC1xhsSrWITSZErBKfHlS77yL0ITfYadJEjFYm
4bXLxQReureykCcI2L3tPP+0M+ZwUshDroBCwKqI1Y8K/c2hYWifrdoAAcsY
M28+VGkOmJp7jfs7AqZ6J6LyKr8FdJK5L3dUEbCCpBfMmpsWMF1tj4VEEDAt
xqDrY11W4OjK/o03hICJLAe+kMZbw0f+6n2VAQTsIqP2mQ0ta1gMZ70x6UnA
8gieXWyYNfwyLz+oak3A5Df85rkbbYDwd9N/7RgB24UVTRZ320FsZV5BjCQB
q56eKdi/yx64nAwGRMQIGENZjSyPmT3w9GZLGO0nYFYn401KZ+xB6Jk2tZyZ
gN0sS7d5HeQAilopii40dmzrWmn58dJL4PBQboUWyo79uiQddvnUFfCvSYjo
uceOFQ7r+2k4XYHk8VX+t3fYMe4ff9uvProCndK1OkUe7Fh/L0njycwVkO9R
yfWxYse+jnrmPopxAlaSltnu4+xYBnY8V2jZGcrizBr1ZvCYg4/qQ5sfV6G9
rs4YGcdj3evE3luibjAzxftFnoLHfOu2j300d4O9smM8B3rwmGzZe28q6gZB
/fY3vtTjMf4w071cSe5gvOuqSEQ8HpNXrRNTN7gO6wkBkSjgMdPd6rZtEZ7w
mf/t4lkVPFagQTQ/XOwJIwWs+r0KeKzm6b9/HV2eUN3w364JCTyG7zow173L
CzxmC9M3d9Pvl/Lknn3mBXNyQ2WKC2wY4x/7ziddN6G3X/pDaTwbVtW/oiJv
5g2NVjfl5WPYsHmFx4hpiDeUztclN4SzYcm4IZPWMm+IXNe0eu/Phil+/nI7
htkHTgtZzn26woZ1TRhpdNb5QP2N8F/CymzY90xvTi+ZO5BLmuRLnWHFbiy1
zddYBECCNbApj7NiDy9dPuYUGwChRc/WaCOsWKOHgb9HcwA4al7uO9DNir3c
6NqOlbkLIj4LYU9rWbHcXSvWJPw9yJn4+b0ghhXDS+Keh/YGwrMytvaXiqwY
pkwdumQcAvEbrtVmsqzYWP32SNvNEAg+2/nsjyQr5jxjEGiXGAIO0w8DlIXo
12eS+o8Oh4DgHm65NwRWzE1rlueidShkBfBntE6xYCGl+Qmfve5Dxnm5m4NR
LJgYw23GE53hIEo839kfxoItya49IX8Ph9IuR5HeIBaMxvN87OCeCGjQSxro
8GbBtHKoyLhdBNAM/hxvusSCfc+iXPn8OwL2XnyzWqTMgiHTGWXX5SIhzlrH
O/ALMyZo3Pz394do2Mvv2BMwz4xl8FTpb/+LhqxxfzG/KWasnERWPy0ZAxW2
ZcO3hpmxTwWHWB/cj4Fue7LS1bfMWNXhOv9/Jx8C/srw74tpzNgUc9PT6eex
EHrt0h0JHWZMJW6ZucIlHiYf2WU0nGbG7h5y7sWFxYNKlTWmq86MXT4qOhr8
LB5+/jLFe8gzYwEpze4btHi4FHQ+9cVBZuxw3R/HGYP/AEmQr1f9yYS1FXap
1CAJsF3Hsq7/hAlLwLVv5J9JAqtRHP9UMhP2JzdHPcAlCWr/7oBnPBNmLz8Z
EhSVBB4amw8SwpmwGM61Jp7eJJjoXN5HucGERVmPKQVaJkPjBOWEgxYTFq5n
aevqlwIBTCW+N5dwmK5EUvjSZCp4pNmxOizgsFY1A8JF5jRwPLY7WX8Oh9W5
lpV9kkiD89Z3Xxyh4TDakPKnVO804K02WJpsxWETUTaeMuR0qHFcddTNwGG4
t4zMyrpPYPntKQNRXRz26PKFs18/Z8Ks+Y/xXWdxmOlDpl0Ou7NgeCnffQfB
YalC1VQ2yIJGPnLUqBIOOz+gsbmSkgUxXjMt8SI47PGfsBYZnadwRDhC+d8G
I9Z8aiX7lfUzuBTcJzpSxIj1tBjfPjiZDWa0p+oTuYzYI5M/QRW/s+H8cU+L
+SxG7CHDAwsrcg4ozHM9/JnEiD1gk6jDaeQAXtt4lRTCiE0QFHlT83Oggjz8
9pwlI5Z2PaVp/lYubGWN2r1iZ8R27dyIChTLh5U/JXcwZkaMSrs7Ha2RD/OG
AQnvdhiwOZybZI1tPvTi+NuHfzFg3k8ZabYp+ZDjbCvzc4YBy5YzuE5mLwDt
o9Nbkg0MGPd0dsnGagEkv/mYmuHGgKmS2bwtp4vA7k564AknBiwsb9yJiiuG
I/IXrgzYM2DnlRcaA8SKoaGo/hjelAFzX+tfOOZeDJOJMe23gAF7H/UdMVwv
hsNucmvn9zBgBTa1C8F8pXBTZjPrZ8AOesNd3oT/Tjk0TB3hKBPZRj3L0lKH
Targ7inG8nTebfTguRulrlerQC2Nph9F2kZr16bUOAOrADOOjnPe/IdO3V/7
GV1YBe/avnILD/xDlw1E91huVcFQaQVfSsg/VGwm5fnpghew7KtwOHj6L5pg
sdTqxl4Dh7gQTZOsLZT8pd8xiqUOHsnO+LslbqG8XqqUCqE6WDcMrQ6O3EI5
j3IHfVGtg+7/WkXLb26hl99JumTdrIPbu3XYWM9toUua3uGsM3XQvte4u+77
Joq8Yt7ofVsPbgevmB3Q2ET9RaWVjyc2wAvJSLfZuXV0gQm9d+l2E0y1VQkp
Kf1GbfVZ1F0CWuCjdPJxtHYVdX/dmGj3+R3sCixWOsr4A53av3f1BVsPSCt9
l85f/YbqEctkl9b64b7WUv+rO5/RPrnZB7mhg9Cs/e2CwuXPKElu2Ebj4SAw
6H/trdD/jPLXmO4eSx6Eu6ZfunNFPqPl5iKbjMWD4OP8sSO2+xOqLb4Zyt83
CK6RE9gloU/ot6YQ0YD9Q6DX3VPJ3jGPmqJLfxPLh4DHpCLect8sGqWuPfSx
eRheiMc0nGGaRQUo+ZvpncNguOEyL/d9Bn00+V7r/MAwRGcJnyS8m0F/2Cwd
ejwzDNsLSVMNPjNoOklL6svOMHy6F3CUf2Qa3fMvwNJFdQQ8LvyX+kZiCtVj
FWROLh+BorXz35IZp9C2xij1oJoRmE1jRjxok+inx9PZjq9HwGze97NA1CTa
tWnWtuf9CICfnVLwwgQanNhbITY/Aly5UkOaheNocdnuJ6u8FHjxu43cITqK
RjF2ZXPeo8Cjkpxm9Q0aegjXiYu/TwF3uyDvlz009NY3gj57NAVE20+O5fjQ
0D3f7QOmUyiQklxacK+Dipo3b10UqqSAv8J/avLXKChiyvFmcpoCZgvXV4oR
ClrVVdDT9YkC8hnnc4V4KKikQLzW828U+MbEzE5qGkHD43nOWq5TwG7QZ2iB
PIJ6pY+jJ8lU0Lxp455VPYTGWDqtCahSQUBcWYAncgil3LakeSBU2KLxfIix
GUKP2xDLa85QoUajT8mPZQj9Fn2NWcSQCuK7NHEm5oMoowBUhl6hAqHycBr7
1geUcW8XySyGCvljH2O/hPWiejrp0rwfqDB6d+/TTPledKgp+cHwEBVIAucq
jWZ7UFZHjutRVCr4OBQNvIIe1HBgom1oigpnP7rti97sQpv8E5U2lqiwsPz9
maTne5RN5MJtbzwN+OOFXkwKvEdHJUlBaUQaGMoZtST0dKB+RzgGq0k0qL/1
4uOmZAe6sb11rmsPDaLWb0t2fWxHfwUUMoQL0UASt1ntbt2KJu9+XCKkRAO7
XMk2QUIr+qrWIr/wJA0StKxHButb0K4Cp2pRVRpsRjSuq+5tQZXl/P8xIDTo
IgapcXx4i6pU9qxr6NCAofy5ARb0Fg0rpJzy06WBgsG0/e2jb9HK3vh7Bfo0
yIjXCB2PwdDgjNzFWSMaUCXxjyxjm9D+5q/Sc5Y0QK5frXy7+AZNfd5I7rSm
QdHzzgEJ7Tcog1PaWIEtDfwUYvdt4hpRqaBIMc1LNNivzp2dfucVinA5nt1x
oUFo8K0W3Eg9+rXqkmLyVRp8bR766CZfj/qc7v4r5E6DxnOPJVWXa9HAa3c4
93vQwNaIv2bscg3akLzKnHCLBt9Wfyl7t1ajcvtjoP82De6m9KEksWp0pS6r
hNmH/v5joV0an6pQZb9yDsM7NJAOtDEaO1uFnsvaZnDxo8FrISXK7cJKtHfe
V+i2Pw1qugbaLnyoQJ/9I4573qXBEFfEh9CEcrR2muLtcI8Gq6bKEy8vlqEm
xKNKZwNpcHz66dqBkWK0fcZCfC2IBkZiFxkuPC5CZX4pmzQG08DTjZUj1KIQ
ZTvUlOcfQoPna9cOLYzmoQMBZ0tooTToVRY6diAjF03MfmHrf58Gy4GDKga2
OWjw6H+yu8JowNkacTZEIBtFexVEsui24L6d54o+RT2f/ZETDqfB44zR170a
meiXbxr26XSPiGsMKrSmo1M9EcXsETTYU1W4mH42Fb09qsV1g+6LqiQc4/tk
VOkIa2In3Qltt/lcdBPRHV0HOf4HNOi/MCbb0xOPdlitLV6mW6Dmfrzzs4eo
7aIHmk33kw5D9Hj+A5SRO7JimG7eiYPL28Wh6B83pvoduqXmhpVTbAPQTa7K
McFIGohzeD4+6uKFpue48inRHTx0ZOhAiy0arrHbS5NuafKEG4uMFjQkZM9q
0T3yI/Qp17or5DRxeajRvXLh8M8bN32Az+vqbmm6AxLPdrorBIMVDR3gons7
0O/J02PhMF4sX/aV/vxgt7Jrg5LRQOJdedpIN5PZlBqbeBxwjEtV3Ke7RSjq
QSZXAkjLSlAQusNSRDxPPEqC+/2KB9bo/XGWo9HiA/ExGG6W+GfSzRZqquEe
lQba7ku/TtHd8WdZgoUtA0YdrscO0Ps7+nok99OwLDB6XKBhR3fBj/h7/CHP
YF5baPc0fbxcXCSda7dzoNxbiqudPr7aIr5W99XywPgDs5ok3UcmWgwM7+bD
HeeKqDB6HhaNbU8sbhRC/9Hg8AP0vHRylkjVnSwGb0Y9JQt6nko7fguG+ZaA
vs4xQgw9b9fU4/ECv8oAvcIoOEjPp/7G+N9F+QrYvvz90gI9v0drJH7U3XwO
Y1KrXasBNFhPmvl2ZL0SLNnq+Zbo+X9FCBhu9q6G7AbepqveNHgmwzP4XKQG
1Fq1DXno9RRh+Lw/o68Gkq4Vmb+8SQOTlLkuH4laiLaP6hm4QR8fYb1myYl6
OJWq+eg+vX4pWp/QfdGvwMXkJ+Mgvb6bXILfMJ9ogG38o629zjSIKa+pn4x/
DcYUcvRdR3o+lA8+T9BqgspNA6smKxpw2NSVBf1oAntHptMvLOj1FmhUci0L
BdsLp9vTzWjgMNtsfOguBudCRgt1jOntO/JH/9/wW1BO+CEpSP+eva+216qK
aoXt0/t2ShVocKpNuuXwdCvg+9vZvsrRoHJkQyNLqQ0oia+mBI7RIGUjEWLm
2sA0IZ/DSYIGV6BDxUntHVyYDupwP0iDnU5ZOb4f78FUst/FmYkGN8f/PY87
1wkVdjZ6aztU+LTUeZQ1qxM4/rw77fuXCt1cTtKr57vg1VvBQJtfVEg3Szvc
k9cNggaCRXmfqKA4yygQYtEH1dpMKrLvqHC0wfyHbHEf1C5GuVq00OenhPLW
6Y0+OFIuY+WLUoGYXab4TL8ffoevpabVUeGvocX4znI/HE0bYvEspMJE5XMJ
VG4A4lnfdriGU+Gpp12rWt0QXO7esixXoUKGDXtF8tQQvPkadLtOkQqp2jWP
l9iGwfcJ8rtelgrxQgT3TIthGJDyPZsjToXg/pe7/m0MA+VVWSOJmwqXZDnt
G09RwDJ3XMHkMwUOrbzeUGmmwZkcgdeNMRS423M6bG2JBoTYf0Xq4RQYKeki
VfCNwgjLy6t1gRSIdho7JOw1CiZGZyJivSiwMrqpzyY0BuatxkI9ZhRoalPO
Gbw3Du7LbhnZghSwelJ3/pryFFyF9t6pkhHQyaX1GFjMQnx3nHxv8TCshFc4
t12fBeUz1YE+2cOQ6np/R/X+LCy5fNTmTRuGBRkZOYmKWeCn5IRqRw5DZH1w
EhPzHMi6duTbOA9DR89h6/rnc5DxuDLGRngYzq17LwizfYSUHNlKXOIQnNHn
Zvr18jO8FtSVlHMZhDh7SrBs3TdQXb/kNLfrA7wzOMhpyP0D7p459b30Uzcs
CfMEDqSvAs/3i/bU/R3gfVvqUtze38CUqrJKqGoByjiXsXPHOqhbvFVkam+C
8zFO1NsD64BF/P3CU9QEjcoNdvfH1+G3N0ORcnQTPEu57P5sZR1ONeyzrTFo
AlfD2rBR3g2Ik0528aW+gc0W6zqDqxvga/kyQvl7I/CXFvCfIGzCLvxa35DE
a3DwO/WZTW8LBIsaZXWH6kDySsfwstkWVL3hMsypr4NVA5PW4UtbsDI8nUjK
rIMI0WvZub5b0KNZ91DcuQ7K+p5YQ+4WvBL5bGayUQsbYlt9PptbwCNpHVl4
qBYSBl7Vfyz6C++1M+BIZA20SJ2IbmHZBhelXGne+CqwO2aS+4O8DeZqzXYS
AVWwftyrUXD/NjDWNd7Rc64CaZXS5YCj20CsEDbuOFUFSdqCFxXMtwHLk+NN
WawEZyc2/vyibchvyy4O16kE/FNKeYTuDvB90uMQlKiAnJy19hrTHTj6L/lh
IVMFnCrYNT1rvwO8+Z7BxpPl4Fmuyw23d0Brdi2OnFQOtNeoz5+MHYh1vDgv
ylgOJdRCcF3eAc4rMm8rZ0pBnL1xIU+bATl8RfPy19fF8PPdUbccfQakNCU6
yOBJMTRFZH99asyARNiasn7wLwYz5gfL6TYMiFvsB14FlWII3zFai/dkQJRq
9ld7NhTB/K/PO3dTGRDJPUhCLVYIObO795kuMCA4DWUL/Hw+eGRHpBovMSC/
jKiiqu/yQcVhg8/wJwOiTZR0jSnJh4GJSX7dvwyI7PsyrjCvfGCkFYtocDEi
xwlre4cY8sGhD47KnGREMjMkkGnRPDjY6H6GJZIR0V2RJsmF5sAevs1Nj1hG
pFzFNKPPOQc4fCIrqQmMiKrfa91Hujnw91j+gbJMRoSAOFW78+TAaO7kD+Nq
RiQ45NfhvJJsSIkxyno2yYj8Nnmd/Gf0GZCsT/xRVcQhqgWTjRz5WcBa31aW
r4JDbN1PT6x7Z8G/PSaOZASH+O4ruyV4Lgu+9Xr2zJ7HIUVOX88cWMyETs2S
3CgHHPL7lJFZx/FMeCB50JASg0NK6jLbenufAMMmrvjmLA5xljwpoiGbBg5z
tNWgzzjEU+JfTxchDbDuSvXYbzikwyMdCfuYCsFP7YYKf+OQp24O0/eepMKO
VsPOOIEJqb0wPhTHngrbcV5m5+SZEIsXamscyynwV2yaiT+MCSkIlZV1oCSB
DbnOQCKKCblKCfa2rEuCxvXYNKVHTIiPn9vrgMdJcLdL9ZhRKhOC3hJ7oWKR
BFuej60iypgQ7sldMlljibD52qBqZYgJef02PnL0SwL8MXpj1ybGjIhFLjwR
PfQfhNKeT6hLMSMpej27q1j+A9KlHJt6WWaEK6BNzXUhHsQ9H1iVqjIj8g8f
fjetiAeTR0Zm/xkxIw7PBFslTsVDZedHfdt7zIhODmf4XvQRXD1NUvs1xIwc
XsXJ/noQA2udDI0eo8yIbOT7w0TzGAg2XlVZmGJGGG/cMHQXj4HUS9STY4vM
yIqf9ii+PRrag3IU3jKwIGJTE1ee46NBpFFJOlaaBTmwvZhn/yQSxhTsD4iF
sSA/zURUcGvh4LyhSA6PYkFiJG588+4Oh5U3HEwfH7Egmy2KvIfzw4H5XMNi
XhoL8jHfowIxD4ejljwNos9ZkMFitmztpjAIvtdlITrKgvSRnpS5Pb4P4u0n
Ug7JsiK2jgI8W7dCoDKaFH1fkRVZ9OUZjrsYAioXPt6bU2FFVjaB3VI+BC5Q
E5xyz7AiXS+VGh+sBsOdxSWFQ9asSM+2/ZiBTzB0kfIGRSJYEaOdJYcEQhB4
mnPtEhlnRbSWr0mfexQAjkXH0sVmWJEPm215e2wDwHTD4JDEJ1aEuNR+9ph0
AKg8iVWUXWFFJHjL/c53+QPLFMFKnZkN4eN608XJ6Q/pziy5VtJsyDL+XfvN
rDvQ6r2pkHiXDSlpw58++Nsbatv5mlJC2BDmzJLU4R5vKN6nfC49gg0JyPA0
6Mv3hkevfC2z49kQKV7CnXAzb7D8t3bveR4bMmzwVmy14TYsh31v7+pmQxKP
WfBGxt0CvqR5C+aDeIQz8q++rpMXnLwvuPe2CB5hZXfffq/hBWY3rQbnDuMR
0kK0epSAFyQY9uu3HMcjFK570++onsDB2agZqo1HKnJjPqkYesJ2eKI0w208
okR78fhssgfM+2oy/O3EI9nOegKTw26Ac7n3xr0fj7S39IvFZbqBkFm9/9gw
HskTdT5U4uQGtgpHfzVM45Gb/GKmB/5chZEVvkW/33jkGrs1F1XgKry/+mPw
jzA7QqRYR0qEuECF9bPC1TvsSKqAsVn3wyugQDm0yRrIjjDGJQ97XL4Cr40L
9fbfZ0c+yijetlGhr650Kn4gsewIb2y40r4vl2HuRKPqo2x2JCP7HcO2zmXg
3UPtO9LJjng+XueV5nOE0G7yuu0BAlL+nqWUdcge8NqJ572ECIim9Qhql2AP
cS17M8PECMic3+ViOSN7yGg4qFl6jIAsLwSOaPXbQV2R1MP10wQk7MzyMGHI
Fr6FnRNKvEZAhCsVXrn9sKbPU0HaHW8IiBqDAmYZaAHjvz6Rm5sJSOvhB9WZ
uhbgWGFAef2OgMzLkt01+CzgmqCA8/MPBOSwRmdR/ktzCGV8cz/lIwEhjvkc
7P9pBhVtm01XOIlIG+5siVigKSgEOkbYcRMRlmCrWX4jU3il1KlvsY+IrKud
0nETNYXWwrRxXWEivR5ErFm6TYAWdXLzuCIR2f13ulla0ASYDXwUGW2JiA83
cbx1yBiiWSf/bl4iIq55ZnLjZcZARs+0rjkTkdTENytIuDHsl+W5uOBJRNZ2
/Xm8omQMx7hrPPvCiMjXQkW+0UwjsBr5UZpZRqTXa/DcFT9DqLK7LqLyl4io
qmtf/v5ODxxfrhx8xsiB1J7yCtEO04M9HLf5WNk4kIMz597Ja+iBzyt/roFd
HIjn0Ih9Y6MuqOyJ3L56mAMx+OVx2rfhPDS/zxlNM+ZAoueNK/L7tOGWkPjI
jjkHMnP2dfyzJG0Q9S3+4GTLgbCnPnrLb6VNX39Udsi5ciBTUkSe5E/nQDfo
Te37exyI7qlQshvLORhSoCZsFHEg6bGugn2WZyA8xvqRfQUH0lMhdtBd/Awo
zU5GtVVzICW4Uk2/VS1IjfsY/F8TBzJh5nlr4ZEW2C7+9JAY4kA8TrO+2+g8
DZ+ecupa7nAgMkUT7EfMNWGdcJrplSknwiPxTvnfLQDuZVJSsxUnwpZ+UK9U
CkDqw6hotz0nckKO33V1Th3sHt88O3WVE+HKGtmnb6YOLYdyolgCOZH5Rgdg
1VSDR6cYuYwLOBEXsWadZAVVKBLseWZdyolM8/Wl2/xSgbe4NDmnSk4k6Ms5
KKtVgbUO2Yt3GjiRDkNZs2kVFbAydUjJ6uVENjrPLwbqKIOYB8r/9Tcn0sLl
tVATeALUjWLK17Y4kVm/718enDsBFgrm6tsMJKTyeJjlINcJiN5ctt9FJCG1
b3Tb+vKUYCVCIPeEIAkpkynZ0hpQhMan9yTCzpGQ+q8sceaaCvT/UFWlg6kk
BPdFQF3USw4IqsS3jZkkhPXTiz13NeXgbd6ork0uCflR6KmjvUcOZO/4XXpS
QUJ0n8oUKr+SBZJg3UO+NhLSbLiYeRkvC++vHZ/j+UlC5vW1+Za8ZSB4hNHj
5R8S0nn52ZGT4jJwEvmwbvKPhFiKW2XpUaShYLcnKQlPRlKrF706VaUhrKFc
mVuQjHwajAn6zCkFCF4inqRHRgJ1fIOFh4/Autf6/gojMmK9wEs79t8ReD72
Ll/fnIzcdZDe+03/CAg8d379kL4iWcrG01zeH4a/pnmfCH5kpOvpz3tIhzjU
5QqqsRWQEXXjp7+F5kXBg/P7u4JSMuIurV9oUiIK4r5NxmeryAhp1FlcwEsU
ks7buoY3kpG59oH1awyicPNHeiLTIBlRSbDxHhQ7BJLWbgK5VDIino4S4lZE
YKZVuVhzkoy0cEzGDr8WAcNUalPIFzIyOe4qun1RBPC4Ih3h72Tkmk5gzoSQ
CKDuvkPYGhlZuZcyp7ksDD7DZ+0dNskIto89T7pRGP5vfwry//tT/gckznYZ

       "]]},
     Annotation[#, "Charting`Private`Tag$3686#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Standard Gaussian PDF\"", FontFamily -> "Helvetica", FontSize -> 12, 
       FontWeight -> "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"z\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.0\"", 0, Editable -> False], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.020000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.04000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.06000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.08000000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.10000000000000002`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.12000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.14, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.16000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.18000000000000005`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.20000000000000007`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.22000000000000008`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.2600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.28000000000000014`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.30000000000000016`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}, {
      0.3200000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3400000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3600000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.3800000000000002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.40000000000000024`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}}, {{{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}, {{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOJ1QU+M7BRfO8alRXiC6FeSFjEgmuMWezuIdlAy6gbR
fCIP54LoY93ivBlA2rFBTxVEr+EqtQPRP36fcQbRQqz90zKB9Mpvi/SzgPRV
4cyIPiC9bdPyOhC960TXbBAdKf79NogW7Gs41g+kN8UEvgXR/77IfwbRvuVO
IhNA7vGxDwfR7Zt5YkC03FXbKSD6yK8jO0C008ufT0H0JP9Vn0H0u0w7iZ1A
+saXPDUQzbklqwtE353ONR9Eq/rc3QmixZxqz4LoU5rhdhbKQH+xlAreKnjt
eIXrq2dz4WtHC/u1USDaXKLiMoi22nDVeWXxa0ednqguptmvHZ/sjyv/ePa1
IwCXxZnF
  "],ExpressionUUID->"8279ba39-a335-46d5-98d5-b4398ffd4497"]
}, Open  ]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example #2 (logarithmic axes)", "Section",
 CellChangeTimes->{{3.579014435600346*^9, 3.5790144423552837`*^9}, {
  3.63930159181301*^9, 3.63930159709956*^9}, {3.639305743544083*^9, 
  3.639305760646989*^9}, {3.63984159254801*^9, 3.6398416002108297`*^9}, {
  3.641472023104082*^9, 3.6414720407898827`*^9}}],

Cell["\<\
If the ordinate is logarithmic, an exponential function should be a straight \
line.\
\>", "Text",
 CellChangeTimes->{{3.641472659012047*^9, 3.6414726802985897`*^9}, 
   3.683045401549787*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.001", ",", "1000"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.633184647633905*^9, 3.633184681266508*^9}, {
  3.633184787895357*^9, 3.6331847936304502`*^9}, {3.641473029128387*^9, 
  3.641473033151293*^9}},ExpressionUUID->"4d320855-6247-4f52-a271-\
c30b6b84802a"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJxF1OlPEnAcgHEgPEASlCwpzaPmig11unQeTc0YbiWaCrVcZijNGYXXTIda
TtS0trzQifLCI9KxsrXltRoWpkuLXE7M6KBMvLISZZIX1Ybf34tnn//g8eAJ
4/g4DAYT/a//Fs5GG8xm6sCOetFeo3YTyaZ8Wev5g3QPytgSriBfVNbY6vRI
W+/JgwNvkHU5yaduNiEV2Ox2TCDSis/yo11wBKnvXwpaqx3AOJU05egIBRT9
Oi6omiaDvdel6V0x9iC7huO+3UgCWbJn7KgfRFA+nK/JTiSASeI6p7cdNmBR
8q6HdlRrEMNwU0aW4sEPtxvLFRM40IWY1rl6AgteOUa30rqYlTumBH7uUKk2
QHpesPlauwls+RQ/mB9hBGeLnUJZzgawX3KEOcddAn3np1Z9ZHrwZL+WsMXV
KZkWMzq7TA7UcWWmRe7lQy3vCvqUCRaHX09V+sf3hr2yGMx4/ji2YTwsxCIu
1+ljKk0H2pBii3k/9WCJThOZ1bYUJrb4qKkstsiwDApbUynfuUYwKV3qWl5s
AivO5Ab5N2+A+D0S/Y31bXBytPS3mIwN35Ej4gVIVThQYLfoqT6PB90UQ/XW
C1agqDcyntxkA2bIBd0BPgSQhAvkec8QQebVBAm9lgQ697kKmYftwZqsW9W+
k2QwriyGIeumgPREMae90AHU6AmttRxHUM2biXB0o4Jf8fdNEk/kqjyti+aF
pC0uungwkKnZhjWfEOR6iflB9Fmk1z3a/oq7yCCWdoxUizw931xeVY/MZLgb
G2TIp0+8xuQKZNyQf9ngMJKfZgyNGkXmEXtWRtVIGTv40vgEck4THvptGrme
h1vhzyJ3HxjsnF9A+l1k7VteRjKxBHWOEXmubURsMiHTmXdCCjaRlm+BfwEg
SEAN
       "]]},
     Annotation[#, "Charting`Private`Tag$3889#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -6.907755278982137},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Standard Gaussian PDF\"", FontFamily -> "Helvetica", FontSize -> 12, 
       FontWeight -> "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"z\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{-3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-2.813410716760036, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-2.525728644308255, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.9661128563728327`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.83258146374831, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.7147984280919264`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.6094379124341, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}, {-1.514127732629775, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.4271163556401454`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.3470736479666088`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.2729656758128869`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.2039728043259355`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}, {-1.1394342831883644`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.0788096613719294`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.0216512475319808`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-0.967584026261705, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-0.9162907318741544, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}}, {{-3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-2.813410716760036, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-2.525728644308255, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.1\"", 0.10000000000000002`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.9661128563728327`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.83258146374831, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.7147984280919264`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.6094379124341, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.2\"", 0.20000000000000007`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}, {-1.514127732629775, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.4271163556401454`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.3470736479666088`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.2729656758128869`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.2039728043259355`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.3\"", 0.30000000000000016`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {
       0, 0.01}}, {-1.1394342831883644`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.0788096613719294`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-1.0216512475319808`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-0.967584026261705, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {-0.9162907318741544, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.4\"", 0.40000000000000024`, AutoDelete -> True], 
         PaddedForm[#, {2, 1}]& ], TraditionalForm], {0, 0.01}}}}, {{{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}, {{-4, 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {-0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {0.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {1.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {2.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {3.5, 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None},
  PlotRange->NCache[{{-5, 5}, {-6.907755278982137, 
      Log[1000]}}, {{-5, 5}, {-6.907755278982137, 6.907755278982137}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[{Log, Exp}]}, {Automatic, {{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.6414727141740294`*^9, 3.641472735817731*^9}, 
   3.6414746120918083`*^9, 3.641474922658497*^9, 3.641474969149638*^9, 
   3.6414752341386967`*^9, 3.641475770091374*^9, 3.64147580851131*^9, 
   3.641476258053627*^9, 3.641476550276716*^9, 3.6414769119276733`*^9, 
   3.6414770214384947`*^9, 3.641559234022066*^9, 3.641559347539968*^9, 
   3.641560147409054*^9, 3.641560312394272*^9, 3.641560526976412*^9, 
   3.641560684103017*^9, 3.6423439227965393`*^9, 3.6830455157471046`*^9, 
   3.683392079758148*^9, 3.683392213496255*^9, 3.683393179843318*^9, 
   3.684518430785063*^9, 3.70514849892432*^9, 3.731852128760263*^9, 
   3.731852219080893*^9},ExpressionUUID->"294f9932-7f43-4c21-a795-\
dadf22116a8c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"setLinAxis", "[", 
   RowBox[{"True", ",", "\"\<X\>\"", ",", 
    RowBox[{"-", "5"}], ",", "5", ",", "11", ",", "0", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"setLogAxis", "[", 
   RowBox[{"False", ",", "\"\<Y\>\"", ",", 
    RowBox[{"-", "3"}], ",", "3", ",", "4"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.39016221101334*^9, 3.390162211392661*^9}, {
   3.390162245676605*^9, 3.390162245789352*^9}, {3.390163923983576*^9, 
   3.390163931457799*^9}, {3.390303264120278*^9, 3.390303274956976*^9}, {
   3.390303362119499*^9, 3.390303383619132*^9}, {3.390303466907736*^9, 
   3.3903034802283382`*^9}, 3.3903131134052477`*^9, {3.46427643575497*^9, 
   3.464276455200439*^9}, {3.46434289703349*^9, 3.46434290145258*^9}, {
   3.529227331346245*^9, 3.529227334242074*^9}, {3.529228361953331*^9, 
   3.529228363655961*^9}, 3.529228411057817*^9, {3.529859047367486*^9, 
   3.529859094782133*^9}, {3.556531771462447*^9, 3.556531842661377*^9}, {
   3.556531926766034*^9, 3.556531942589464*^9}, {3.556532183974278*^9, 
   3.55653219610211*^9}, {3.5565326016864347`*^9, 3.5565326043097754`*^9}, {
   3.5565456982412653`*^9, 3.556545701887532*^9}, {3.557142836011086*^9, 
   3.557142907168467*^9}, {3.557143272994123*^9, 3.5571433176156282`*^9}, {
   3.557143431088841*^9, 3.557143453376718*^9}, 3.557143544242992*^9, {
   3.5571585775971518`*^9, 3.557158588475452*^9}, 3.557223949427227*^9, {
   3.583505138762953*^9, 3.583505187077249*^9}, {3.5835054155311003`*^9, 
   3.583505437770534*^9}, {3.583580794585649*^9, 3.58358079465945*^9}, {
   3.604843540167177*^9, 3.604843668869877*^9}, {3.604843933326126*^9, 
   3.6048439343337603`*^9}, {3.632735782455123*^9, 3.632735790942565*^9}, {
   3.632735871322358*^9, 3.6327358742342052`*^9}, {3.632735920503312*^9, 
   3.632735927838423*^9}, {3.632736217750588*^9, 3.632736223814178*^9}, {
   3.632736268882636*^9, 3.632736309094421*^9}, {3.632736893057959*^9, 
   3.632736906999136*^9}, {3.632738804123653*^9, 3.632738834232999*^9}, {
   3.639306831360304*^9, 3.639306929887392*^9}, 3.6393075355610943`*^9, {
   3.6393078251958523`*^9, 3.6393078286555033`*^9}, {3.6399357906749163`*^9, 
   3.639935800474896*^9}, {3.641472796623032*^9, 3.6414728588227663`*^9}, {
   3.641472956916102*^9, 3.641473003953437*^9}, {3.641473076559669*^9, 
   3.6414730766793528`*^9}, 
   3.6414731123834047`*^9},ExpressionUUID->"bc50a626-c38d-45f9-837e-\
62b5719b8355"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lplot", "=", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.001", ",", "1000"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.64147304332924*^9, 3.6414730448723516`*^9}, {
  3.641473218892277*^9, 3.641473290273508*^9}, {3.641473336336027*^9, 
  3.641473345175671*^9}, {3.641473380790742*^9, 3.641473382542486*^9}, {
  3.6414734130457687`*^9, 3.641473442946225*^9}, {3.641473481324518*^9, 
  3.6414734814594717`*^9}, {3.641473548762589*^9, 3.6414735491935463`*^9}, {
  3.641473676734715*^9, 3.6414737769315987`*^9}, {3.641475607426839*^9, 
  3.641475609044216*^9}, {3.6414757905645943`*^9, 
  3.641475791915353*^9}},ExpressionUUID->"772f115b-2df2-4f48-b794-\
1401172700ba"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJxF1OlPEnAcgHEgPEASlCwpzaPmig11unQeTc0YbiWaCrVcZijNGYXXTIda
TtS0trzQifLCI9KxsrXltRoWpkuLXE7M6KBMvLISZZIX1Ybf34tnn//g8eAJ
4/g4DAYT/a//Fs5GG8xm6sCOetFeo3YTyaZ8Wev5g3QPytgSriBfVNbY6vRI
W+/JgwNvkHU5yaduNiEV2Ox2TCDSis/yo11wBKnvXwpaqx3AOJU05egIBRT9
Oi6omiaDvdel6V0x9iC7huO+3UgCWbJn7KgfRFA+nK/JTiSASeI6p7cdNmBR
8q6HdlRrEMNwU0aW4sEPtxvLFRM40IWY1rl6AgteOUa30rqYlTumBH7uUKk2
QHpesPlauwls+RQ/mB9hBGeLnUJZzgawX3KEOcddAn3np1Z9ZHrwZL+WsMXV
KZkWMzq7TA7UcWWmRe7lQy3vCvqUCRaHX09V+sf3hr2yGMx4/ji2YTwsxCIu
1+ljKk0H2pBii3k/9WCJThOZ1bYUJrb4qKkstsiwDApbUynfuUYwKV3qWl5s
AivO5Ab5N2+A+D0S/Y31bXBytPS3mIwN35Ej4gVIVThQYLfoqT6PB90UQ/XW
C1agqDcyntxkA2bIBd0BPgSQhAvkec8QQebVBAm9lgQ697kKmYftwZqsW9W+
k2QwriyGIeumgPREMae90AHU6AmttRxHUM2biXB0o4Jf8fdNEk/kqjyti+aF
pC0uungwkKnZhjWfEOR6iflB9Fmk1z3a/oq7yCCWdoxUizw931xeVY/MZLgb
G2TIp0+8xuQKZNyQf9ngMJKfZgyNGkXmEXtWRtVIGTv40vgEck4THvptGrme
h1vhzyJ3HxjsnF9A+l1k7VteRjKxBHWOEXmubURsMiHTmXdCCjaRlm+BfwEg
SEAN
       "]]},
     Annotation[#, "Charting`Private`Tag$4449#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, -6.907755278982137},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Y\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"X\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox["0.001`", TraditionalForm], {0, 0.01}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox["0.001`", TraditionalForm], {0, 0.01}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox["0.01`", TraditionalForm], {0, 0.01}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox["0.1`", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0, 
       FormBox["1", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox["1000", TraditionalForm], {0, 0.01}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox["0.001`", TraditionalForm], {0, 0.01}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox["0.001`", TraditionalForm], {0, 0.01}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox["0.01`", TraditionalForm], {0, 0.01}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox["0.1`", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0, 
       FormBox["1", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox["1000", TraditionalForm], {0, 0.01}}}}, {{{-5, 
       FormBox[
        RowBox[{"-", "5"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-4., 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3., 
       FormBox[
        RowBox[{"-", "3"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], {0, 0.014097744360902257`}}, {
      0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {1., 
       FormBox["1", TraditionalForm], {0, 0.014097744360902257`}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {3., 
       FormBox["3", TraditionalForm], {0, 0.014097744360902257`}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}, {5., 
       FormBox["5", TraditionalForm], {0, 0.014097744360902257`}}}, {{-5, 
       FormBox[
        RowBox[{"-", "5"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-4., 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-3., 
       FormBox[
        RowBox[{"-", "3"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {
       0, 0.014097744360902257`}}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], {0, 0.014097744360902257`}}, {
      0., 
       FormBox["0", TraditionalForm], {0, 0.014097744360902257`}}, {1., 
       FormBox["1", TraditionalForm], {0, 0.014097744360902257`}}, {2., 
       FormBox["2", TraditionalForm], {0, 0.014097744360902257`}}, {3., 
       FormBox["3", TraditionalForm], {0, 0.014097744360902257`}}, {4., 
       FormBox["4", TraditionalForm], {0, 0.014097744360902257`}}, {5., 
       FormBox["5", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None},
  PlotRange->NCache[{{-5, 5}, {-6.907755278982137, 
      Log[1000]}}, {{-5, 5}, {-6.907755278982137, 6.907755278982137}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, 
    Charting`ScaledTicks[{Log, Exp}]},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.641475808690453*^9, 3.641476258333596*^9, 
  3.6414765505472717`*^9, 3.6414769121902742`*^9, 3.641477021699651*^9, 
  3.641559234315115*^9, 3.641559347839757*^9, 3.64156014757938*^9, 
  3.641560312537745*^9, 3.6415605271341543`*^9, 3.641560684263227*^9, 
  3.642343923031304*^9, 3.683045515932662*^9, 3.683392079941617*^9, 
  3.6833922136854677`*^9, 3.683393180024118*^9, 3.684518430996641*^9, 
  3.705148499141252*^9, 3.731852128955456*^9, 
  3.731852219436399*^9},ExpressionUUID->"310da267-3da5-4d87-af1f-\
fc21acbd4462"]
}, Open  ]],

Cell["", "PageBreak",
 PageBreakBelow->True],

Cell["Both axes can be logarithmic.", "Text",
 CellChangeTimes->{{3.641476467001358*^9, 3.641476484408115*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"5.5", "  ", 
       SuperscriptBox["x", "3"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "100", ",", "5"}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.641474196145721*^9, 3.641474320537818*^9}, 
   3.641474445589335*^9, {3.641474519108183*^9, 3.641474520435936*^9}, {
   3.641474681600397*^9, 3.6414746878789*^9}, 
   3.641474874970578*^9},ExpressionUUID->"52db6c0c-2ff4-4865-9209-\
8014a8e30ec9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1188.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "7320.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "22528.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "50935.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "96668.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "163850.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "256608.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "379065.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "535348.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "729580.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56", ",", "965888.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61", ",", "1.2483955`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66", ",", "1.581228`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71", ",", "1.9685105`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76", ",", "2.414368`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "2.9229255`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "3.498308`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "4.1446405`*^6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96", ",", "4.866048`*^6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.641474311896323*^9, 3.641474322030595*^9}, 
   3.641474447178481*^9, 3.6414745213122263`*^9, 3.641474612353915*^9, 
   3.641474689713543*^9, 3.641474878783043*^9, 3.641474922935486*^9, 
   3.641474969455778*^9, 3.641475234308908*^9, 3.641475770402193*^9, 
   3.641475808858337*^9, 3.6414762584029217`*^9, 3.64147655059997*^9, 
   3.6414769122182426`*^9, 3.6414770217176027`*^9, 3.641559234350816*^9, 
   3.641559347875351*^9, 3.6415601476702547`*^9, 3.641560312555241*^9, 
   3.641560527168807*^9, 3.64156068431971*^9, 3.642343923079303*^9, 
   3.68304551595113*^9, 3.6833920799677057`*^9, 3.6833922137223387`*^9, 
   3.683393180064641*^9, 3.684518431035295*^9, 3.705148499204018*^9, 
   3.731852129040001*^9, 
   3.731852219632072*^9},ExpressionUUID->"485c5555-2d5f-44f1-9137-\
8e9bbd5a80d2"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"setLogAxis", "[", 
   RowBox[{"True", ",", "\"\<X\>\"", ",", "0", ",", "2", ",", "4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"setLogAxis", "[", 
   RowBox[{"False", ",", "\"\<Y\>\"", ",", "0", ",", "7", ",", "1"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.39016221101334*^9, 3.390162211392661*^9}, {
   3.390162245676605*^9, 3.390162245789352*^9}, {3.390163923983576*^9, 
   3.390163931457799*^9}, {3.390303264120278*^9, 3.390303274956976*^9}, {
   3.390303362119499*^9, 3.390303383619132*^9}, {3.390303466907736*^9, 
   3.3903034802283382`*^9}, 3.3903131134052477`*^9, {3.46427643575497*^9, 
   3.464276455200439*^9}, {3.46434289703349*^9, 3.46434290145258*^9}, {
   3.529227331346245*^9, 3.529227334242074*^9}, {3.529228361953331*^9, 
   3.529228363655961*^9}, 3.529228411057817*^9, {3.529859047367486*^9, 
   3.529859094782133*^9}, {3.556531771462447*^9, 3.556531842661377*^9}, {
   3.556531926766034*^9, 3.556531942589464*^9}, {3.556532183974278*^9, 
   3.55653219610211*^9}, {3.5565326016864347`*^9, 3.5565326043097754`*^9}, {
   3.5565456982412653`*^9, 3.556545701887532*^9}, {3.557142836011086*^9, 
   3.557142907168467*^9}, {3.557143272994123*^9, 3.5571433176156282`*^9}, {
   3.557143431088841*^9, 3.557143453376718*^9}, 3.557143544242992*^9, {
   3.5571585775971518`*^9, 3.557158588475452*^9}, 3.557223949427227*^9, {
   3.583505138762953*^9, 3.583505187077249*^9}, {3.5835054155311003`*^9, 
   3.583505437770534*^9}, {3.583580794585649*^9, 3.58358079465945*^9}, {
   3.604843540167177*^9, 3.604843668869877*^9}, {3.604843933326126*^9, 
   3.6048439343337603`*^9}, {3.632735782455123*^9, 3.632735790942565*^9}, {
   3.632735871322358*^9, 3.6327358742342052`*^9}, {3.632735920503312*^9, 
   3.632735927838423*^9}, {3.632736217750588*^9, 3.632736223814178*^9}, {
   3.632736268882636*^9, 3.632736309094421*^9}, {3.632736893057959*^9, 
   3.632736906999136*^9}, {3.632738804123653*^9, 3.632738834232999*^9}, {
   3.639306831360304*^9, 3.639306929887392*^9}, 3.6393075355610943`*^9, {
   3.6393078251958523`*^9, 3.6393078286555033`*^9}, {3.6399357906749163`*^9, 
   3.639935800474896*^9}, {3.641472796623032*^9, 3.6414728588227663`*^9}, {
   3.641472956916102*^9, 3.641473003953437*^9}, {3.641473076559669*^9, 
   3.6414730766793528`*^9}, 3.6414731123834047`*^9, {3.641473991691345*^9, 
   3.641473995515636*^9}, {3.641474030682661*^9, 3.641474082929924*^9}, {
   3.641474736923945*^9, 3.6414747458051023`*^9}, {3.641474891640987*^9, 
   3.64147489830443*^9}, 3.64147529182901*^9, 
   3.641475543462186*^9},ExpressionUUID->"0535e9b0-6476-48c3-ba5e-\
27d0ecdc8ba8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LLLplot", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"pts", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "100"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         SuperscriptBox["10", "7"]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<y = 5.5 \!\(\*SuperscriptBox[\(x\), \(3\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log", "[", "3", "]"}], ",", 
          RowBox[{"Log", "[", "1000000", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BaseStyle", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontFamily", "->", "\"\<Times New Roman\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}]}], "]"}], "}"}]}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "1"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.641474758731577*^9, 3.6414747761889877`*^9}, {
   3.641475326803795*^9, 3.6414753558747263`*^9}, {3.6414754006729593`*^9, 
   3.6414754476160717`*^9}, {3.641475504406865*^9, 3.641475528685607*^9}, {
   3.64147559637187*^9, 3.641475746823409*^9}, {3.641476208911263*^9, 
   3.641476231464541*^9}, 3.641476521768732*^9, {3.641476815625764*^9, 
   3.6414768890471888`*^9}, 3.641476972969083*^9, {3.731852101047448*^9, 
   3.731852101717369*^9}},ExpressionUUID->"33fa3f94-2e7f-44c4-b227-\
7d24df0cf8ec"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQMLAhvfL3X7bc+koPWLe/Uf+6w39eWfAmUcfMzr
tz/WY3ZYO7m//f9pRYf3lr/+OemxOSy/qv23jVvFYeO6/Cl60RwOlm+d15qv
VXU4K/Xh1RQBLgc/O5U8l69qDlHaEz3OVXA7bOeKLcln1nCAmM/jYHaof6fs
Sw0HvzV9rqlbeR3ytKU3Pdig6ZDjNGEv30I+B9YYmTPzE7Uc/jME/k8o4Xf4
/CqnVpZB2yEgR+v0V0kBh9Vn1ucd7dd24M0Ret1RKODgfqZbTklYx2GZstct
k0MCDuvi41lVenQcTl5T+fKbR9AhMUd9jd8fHQehFwcOrQ4SdPBvE0y6lqLr
wM28turVZEGHI+s+l245puvgtvdllsNFQQe5Y35xW5X0HPbFqB6U4xZyCDRd
cb+pUs/hxxL2uieOQg4rFv6uWn1azwEAz96EjA==
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0.02302585092994046, 0.0805904782547916},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
     "\"y = 5.5 \\!\\(\\*SuperscriptBox[\\(x\\), \\(3\\)]\\)\"", 
      TraditionalForm], 
     NCache[{
       Log[3], 
       Log[1000000]}, {1.0986122886681098`, 13.815510557964274`}], 
     BaseStyle -> {FontFamily -> "Times New Roman", FontSize -> 12}]},
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"Y\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"X\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox["1", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0, 
       FormBox["1", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox["1000", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox["10000", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[500000], 13.122363377404328`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[100000], 11.512925464970229`], 
       FormBox["100000", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[5000000], 15.424948470398375`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[1000000], 13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[50000000], 17.72753356339242], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10000000], 16.11809565095832], 
       FormBox[
        TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox["1", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0, 
       FormBox["1", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox["1000", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox["10000", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[500000], 13.122363377404328`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[100000], 11.512925464970229`], 
       FormBox["100000", TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[5000000], 15.424948470398375`], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[1000000], 13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0, 0.01}}, {
       NCache[
        Log[50000000], 17.72753356339242], 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
       NCache[
        Log[10000000], 16.11809565095832], 
       FormBox[
        TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0, 0.01}}}}, {{{0, 
       FormBox["1", TraditionalForm], {0, 0.014097744360902257`}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0, 
       FormBox["1", TraditionalForm], {0, 0.014097744360902257`}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm], {0, 0.014097744360902257`}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm], {0, 0.014097744360902257`}}}, {{0, 
       FormBox["1", TraditionalForm], {0, 0.014097744360902257`}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {0, 
       FormBox["1", TraditionalForm], {0, 0.014097744360902257`}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["10", TraditionalForm], {0, 0.014097744360902257`}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox["100", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImageMargins->1,
  ImagePadding->All,
  ImageSize->600,
  LabelStyle->{FontFamily -> "Times"},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{{0, 
      Log[100]}, {0, 
      Log[10000000]}}, {{0, 4.605170185988092}, {0, 16.11809565095832}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}], 
    Charting`ScaledTicks[{Log, Exp}]},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.6414747787642193`*^9, 3.6414749230118437`*^9, 3.641474969522662*^9, 
   3.6414752344111433`*^9, 3.641475300838626*^9, 3.6414754505712957`*^9, {
   3.641475506013256*^9, 3.641475547740636*^9}, {3.641475712633305*^9, 
   3.641475770472074*^9}, 3.641475808933435*^9, {3.641476233347973*^9, 
   3.641476258515658*^9}, 3.641476550697123*^9, {3.6414768595356607`*^9, 
   3.641476869330175*^9}, 3.64147691229111*^9, {3.641477007053151*^9, 
   3.641477021802341*^9}, 3.6415592344597178`*^9, 3.641559347980816*^9, 
   3.6415601477584352`*^9, 3.6415603126321077`*^9, 3.641560527235793*^9, 
   3.6415606844098682`*^9, 3.642343923185945*^9, 3.6830455160676813`*^9, 
   3.683392080075384*^9, 3.683392213839872*^9, 3.683393180157433*^9, 
   3.684518431131599*^9, 3.705148499339005*^9, 3.731852129234147*^9, 
   3.731852219774373*^9},ExpressionUUID->"abfb8bc4-7baf-4b24-aa47-\
ed006a2c62e8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<LLLplot.png\>\"", ",", "LLLplot"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
   3.63984107879326*^9, 3.6398411135145807`*^9}, {3.6414760623786783`*^9, 
   3.641476070119588*^9}, 3.641476530511586*^9, {3.6414765796710777`*^9, 
   3.6414765825339622`*^9}, {3.68304548841838*^9, 3.6830454897773857`*^9}, {
   3.73185215966965*^9, 
   3.731852160363618*^9}},ExpressionUUID->"192798f5-8eaa-4c2d-b5dc-\
20824d92428a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<LLLplot.pdf\>\"", ",", "LLLplot"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
   3.63984107879326*^9, 3.6398411135145807`*^9}, {3.6414760623786783`*^9, 
   3.641476070119588*^9}, 3.641476530511586*^9, {3.6414765796710777`*^9, 
   3.6414765825339622`*^9}, {3.68304548841838*^9, 
   3.6830454897773857`*^9}},ExpressionUUID->"3c181a37-a64d-4a0e-8c61-\
0544cfb81ee9"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example #3 (using a fake plot)", "Section",
 CellChangeTimes->{{3.579014435600346*^9, 3.5790144423552837`*^9}, {
   3.63930159181301*^9, 3.63930159709956*^9}, {3.639305743544083*^9, 
   3.639305760646989*^9}, {3.63984159254801*^9, 3.6398416002108297`*^9}, 
   3.641472023104082*^9}],

Cell["Synthesize some data.", "Text",
 CellChangeTimes->{{3.6398417638545017`*^9, 3.639841769229557*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", " ", "=", " ", 
   RowBox[{"MixtureDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.55", ",", "0.45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"370", ",", "50"}], "]"}], ",", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"480", ",", "80"}], "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.6398417751787252`*^9, 3.639841930425149*^9}, {
  3.639842725019959*^9, 
  3.639842725352337*^9}},ExpressionUUID->"cb38abb3-010b-4850-b16b-\
d4b25bfb78df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{"dist", ",", "5000"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.639842008628408*^9, 
  3.639842029965867*^9}},ExpressionUUID->"d677fa83-620e-402f-a6aa-\
2b4f51b4fa47"],

Cell["\<\
Make a histogram of this dataset with PDF on the ordinate so that it is clear \
how to reset the axes.\
\>", "Text",
 CellChangeTimes->{{3.639843105323976*^9, 3.639843141730942*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hist", " ", "=", " ", 
  RowBox[{"Histogram", "[", 
   RowBox[{"data", ",", "Automatic", ",", "\"\<PDF\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.639842093105771*^9, 3.639842132818716*^9}, {
   3.639842241653819*^9, 3.639842256529313*^9}, {3.639842293487368*^9, 
   3.639842328890628*^9}, {3.6398424718097277`*^9, 3.639842505687222*^9}, {
   3.639842560305243*^9, 3.639842561157309*^9}, {3.639842592977556*^9, 
   3.639842597040408*^9}, {3.639842628871503*^9, 3.639842680212791*^9}, 
   3.6398427656098127`*^9, {3.639843082334635*^9, 
   3.639843090861055*^9}},ExpressionUUID->"8db2345e-a084-42d5-adfd-\
06502a69d646"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.46199999999999997`], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.46199999999999997`], Thickness[Small]}], 
     RectangleBox[{140., 0}, {160., 0.00001},
      RoundingRadius->0], RectangleBox[{180., 0}, {200., 0.00001},
      RoundingRadius->0], RectangleBox[{200., 0}, {220., 0.00005},
      RoundingRadius->0], RectangleBox[{220., 0}, {240., 0.00008},
      RoundingRadius->0], RectangleBox[{240., 0}, {260., 0.00033},
      RoundingRadius->0], RectangleBox[{260., 0}, {280., 0.00054},
      RoundingRadius->0], RectangleBox[{280., 0}, {300., 0.00154},
      RoundingRadius->0], RectangleBox[{300., 0}, {320., 0.0025},
      RoundingRadius->0], RectangleBox[{320., 0}, {340., 0.0033},
      RoundingRadius->0], RectangleBox[{340., 0}, {360., 0.00449},
      RoundingRadius->0], RectangleBox[{360., 0}, {380., 0.00488},
      RoundingRadius->0], RectangleBox[{380., 0}, {400., 0.00526},
      RoundingRadius->0], RectangleBox[{400., 0}, {420., 0.00491},
      RoundingRadius->0], RectangleBox[{420., 0}, {440., 0.0039},
      RoundingRadius->0], RectangleBox[{440., 0}, {460., 0.00311},
      RoundingRadius->0], RectangleBox[{460., 0}, {480., 0.00281},
      RoundingRadius->0], RectangleBox[{480., 0}, {500., 0.00263},
      RoundingRadius->0], RectangleBox[{500., 0}, {520., 0.00216},
      RoundingRadius->0], RectangleBox[{520., 0}, {540., 0.00214},
      RoundingRadius->0], RectangleBox[{540., 0}, {560., 0.00162},
      RoundingRadius->0], RectangleBox[{560., 0}, {580., 0.00129},
      RoundingRadius->0], RectangleBox[{580., 0}, {600., 0.00099},
      RoundingRadius->0], RectangleBox[{600., 0}, {620., 0.00063},
      RoundingRadius->0], RectangleBox[{620., 0}, {640., 0.0004},
      RoundingRadius->0], RectangleBox[{640., 0}, {660., 0.0002},
      RoundingRadius->0], RectangleBox[{660., 0}, {680., 0.00011},
      RoundingRadius->0], RectangleBox[{680., 0}, {700., 0.00005},
      RoundingRadius->0], RectangleBox[{700., 0}, {720., 0.00004},
      RoundingRadius->0], RectangleBox[{720., 0}, {740., 0.00001},
      RoundingRadius->0], RectangleBox[{760., 0}, {780., 0.00001},
      RoundingRadius->
       0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{127.2, 0},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{140., 780.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.63984256283731*^9, 3.639842634040327*^9, {3.63984266409711*^9, 
   3.639842681168365*^9}, 3.639842731056673*^9, 3.639842766859268*^9, 
   3.639843093436331*^9, 3.6398447430068903`*^9, 3.639936038837514*^9, 
   3.639936201163994*^9, {3.639936750668631*^9, 3.639936774251216*^9}, 
   3.639937107459221*^9, 3.640434702645687*^9, 3.6413056323964157`*^9, 
   3.641306008896299*^9, 3.641306157661853*^9, 3.6413062976736*^9, 
   3.64130713308631*^9, 3.641307723479059*^9, 3.64130787448589*^9, 
   3.64130821696379*^9, 3.641308250292041*^9, 3.6413083997236643`*^9, 
   3.641393257678006*^9, 3.641393450123879*^9, 3.641393652373043*^9, 
   3.641393694472143*^9, 3.641396405510686*^9, 3.641397629772307*^9, 
   3.6414716845540237`*^9, 3.641471989919072*^9, 3.6414722210437937`*^9, 
   3.6414727366642227`*^9, 3.641474613154358*^9, 3.641474923736796*^9, 
   3.641474970273177*^9, 3.6414752351356916`*^9, 3.641475771143355*^9, 
   3.641475809633095*^9, 3.641476259448324*^9, 3.641476551617692*^9, 
   3.641476913180933*^9, 3.641477022676139*^9, 3.641559235410537*^9, 
   3.641559348953548*^9, 3.641560148026908*^9, 3.641560312924574*^9, 
   3.641560528242194*^9, 3.6415606852998657`*^9, 3.642343924870586*^9, 
   3.683045516547256*^9, 3.6833920807517567`*^9, 3.683392214163912*^9, 
   3.683393180553793*^9, 3.6845184317178802`*^9, 3.705148500559743*^9, 
   3.731852220589341*^9},ExpressionUUID->"a228ae29-3c08-40b3-8ed0-\
8f39a9dafa37"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"setLinAxis", "[", 
   RowBox[{
   "True", ",", "\"\<Data\>\"", ",", "200", ",", "800", ",", "7", ",", "4", 
    ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"setLinAxis", "[", 
   RowBox[{
   "False", ",", "\"\<PDF\>\"", ",", "0", ",", "0.006", ",", "7", ",", "4", 
    ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.39016221101334*^9, 3.390162211392661*^9}, {
   3.390162245676605*^9, 3.390162245789352*^9}, {3.390163923983576*^9, 
   3.390163931457799*^9}, {3.390303264120278*^9, 3.390303274956976*^9}, {
   3.390303362119499*^9, 3.390303383619132*^9}, {3.390303466907736*^9, 
   3.3903034802283382`*^9}, 3.3903131134052477`*^9, {3.46427643575497*^9, 
   3.464276455200439*^9}, {3.46434289703349*^9, 3.46434290145258*^9}, {
   3.529227331346245*^9, 3.529227334242074*^9}, {3.529228361953331*^9, 
   3.529228363655961*^9}, 3.529228411057817*^9, {3.529859047367486*^9, 
   3.529859094782133*^9}, {3.556531771462447*^9, 3.556531842661377*^9}, {
   3.556531926766034*^9, 3.556531942589464*^9}, {3.556532183974278*^9, 
   3.55653219610211*^9}, {3.5565326016864347`*^9, 3.5565326043097754`*^9}, {
   3.5565456982412653`*^9, 3.556545701887532*^9}, {3.557142836011086*^9, 
   3.557142907168467*^9}, {3.557143272994123*^9, 3.5571433176156282`*^9}, {
   3.557143431088841*^9, 3.557143453376718*^9}, 3.557143544242992*^9, {
   3.5571585775971518`*^9, 3.557158588475452*^9}, 3.557223949427227*^9, {
   3.583505138762953*^9, 3.583505187077249*^9}, {3.5835054155311003`*^9, 
   3.583505437770534*^9}, {3.583580794585649*^9, 3.58358079465945*^9}, {
   3.604843540167177*^9, 3.604843668869877*^9}, {3.604843933326126*^9, 
   3.6048439343337603`*^9}, {3.632735782455123*^9, 3.632735790942565*^9}, {
   3.632735871322358*^9, 3.6327358742342052`*^9}, {3.632735920503312*^9, 
   3.632735927838423*^9}, {3.632736217750588*^9, 3.632736223814178*^9}, {
   3.632736268882636*^9, 3.632736309094421*^9}, {3.632736893057959*^9, 
   3.632736906999136*^9}, {3.632738804123653*^9, 3.632738834232999*^9}, {
   3.639306831360304*^9, 3.639306929887392*^9}, 3.6393075355610943`*^9, {
   3.6393078251958523`*^9, 3.6393078286555033`*^9}, {3.639843173219592*^9, 
   3.63984322924069*^9}, {3.6398432855083923`*^9, 3.639843286566825*^9}, {
   3.639843756361677*^9, 3.6398437568644733`*^9}, {3.6399360987697067`*^9, 
   3.639936103617391*^9}},ExpressionUUID->"60aa59c8-d987-47d8-8c57-\
023b1b3c7bf2"],

Cell["\<\
Since SetAxes[] does not work on histograms, we need an invisible, \
\[OpenCurlyDoubleQuote]fake\[CloseCurlyDoubleQuote] plot.\
\>", "Text",
 CellChangeTimes->{{3.6398434480983963`*^9, 3.639843507695425*^9}, {
  3.639843625675873*^9, 3.639843627715794*^9}, {3.6399367001040363`*^9, 
  3.639936705326006*^9}, {3.641306511038157*^9, 3.64130651259683*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fakePlot", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "200", ",", "800"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"200", ",", "800"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.006"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.639843514033298*^9, 3.639843595741438*^9}, {
  3.639936111111512*^9, 
  3.639936119432828*^9}},ExpressionUUID->"5bced2ca-796e-4d92-9949-\
23cb6bb976b7"],

Cell["\<\
The Show[] function sets the axes according to the first-named plot.\
\>", "Text",
 CellChangeTimes->{{3.639843645851212*^9, 3.6398436721304617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot3", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"{", 
    RowBox[{"fakePlot", ",", "hist"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.639843676900179*^9, 
  3.639843706210841*^9}},ExpressionUUID->"f421bb19-24bd-4126-87d4-\
d67584b1eb20"],

Cell[BoxData[
 GraphicsBox[{{
    GraphicsComplexBox[{{200.00001224489796`, 0.}, {799.9999877551021, 
     0.}}, {}], {}, {}}, {
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.46199999999999997`], Thickness[Small]}], {}, 
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.46199999999999997`], Thickness[Small]}], 
      RectangleBox[{140., 0}, {160., 0.00001},
       RoundingRadius->0], RectangleBox[{180., 0}, {200., 0.00001},
       RoundingRadius->0], RectangleBox[{200., 0}, {220., 0.00005},
       RoundingRadius->0], RectangleBox[{220., 0}, {240., 0.00008},
       RoundingRadius->0], RectangleBox[{240., 0}, {260., 0.00033},
       RoundingRadius->0], RectangleBox[{260., 0}, {280., 0.00054},
       RoundingRadius->0], RectangleBox[{280., 0}, {300., 0.00154},
       RoundingRadius->0], RectangleBox[{300., 0}, {320., 0.0025},
       RoundingRadius->0], RectangleBox[{320., 0}, {340., 0.0033},
       RoundingRadius->0], RectangleBox[{340., 0}, {360., 0.00449},
       RoundingRadius->0], RectangleBox[{360., 0}, {380., 0.00488},
       RoundingRadius->0], RectangleBox[{380., 0}, {400., 0.00526},
       RoundingRadius->0], RectangleBox[{400., 0}, {420., 0.00491},
       RoundingRadius->0], RectangleBox[{420., 0}, {440., 0.0039},
       RoundingRadius->0], RectangleBox[{440., 0}, {460., 0.00311},
       RoundingRadius->0], RectangleBox[{460., 0}, {480., 0.00281},
       RoundingRadius->0], RectangleBox[{480., 0}, {500., 0.00263},
       RoundingRadius->0], RectangleBox[{500., 0}, {520., 0.00216},
       RoundingRadius->0], RectangleBox[{520., 0}, {540., 0.00214},
       RoundingRadius->0], RectangleBox[{540., 0}, {560., 0.00162},
       RoundingRadius->0], RectangleBox[{560., 0}, {580., 0.00129},
       RoundingRadius->0], RectangleBox[{580., 0}, {600., 0.00099},
       RoundingRadius->0], RectangleBox[{600., 0}, {620., 0.00063},
       RoundingRadius->0], RectangleBox[{620., 0}, {640., 0.0004},
       RoundingRadius->0], RectangleBox[{640., 0}, {660., 0.0002},
       RoundingRadius->0], RectangleBox[{660., 0}, {680., 0.00011},
       RoundingRadius->0], RectangleBox[{680., 0}, {700., 0.00005},
       RoundingRadius->0], RectangleBox[{700., 0}, {720., 0.00004},
       RoundingRadius->0], RectangleBox[{720., 0}, {740., 0.00001},
       RoundingRadius->0], RectangleBox[{760., 0}, {780., 0.00001},
       RoundingRadius->
        0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{200, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"PDF\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"Data\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}}, {{{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}, {{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{200, 800}, {0, 0.006}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.639843711898817*^9, 3.6398437656877623`*^9, 3.639843952562598*^9, 
   3.639844743302392*^9, 3.639936038945632*^9, 3.639936122847886*^9, 
   3.639936201267955*^9, {3.639936751060009*^9, 3.639936774339044*^9}, 
   3.6399371078420057`*^9, 3.640434702979474*^9, 3.64130563274428*^9, 
   3.641306009259266*^9, 3.6413061579983263`*^9, 3.6413062980128117`*^9, 
   3.64130713344501*^9, 3.641307723771791*^9, 3.6413078748641977`*^9, 
   3.641308217217989*^9, 3.641308250584464*^9, 3.641308400064437*^9, 
   3.641393257978608*^9, 3.64139345049916*^9, 3.641393652698926*^9, 
   3.641393694539761*^9, 3.641396405781404*^9, 3.641397630047575*^9, 
   3.64147168486189*^9, 3.641471990277087*^9, 3.641472221350779*^9, 
   3.641472736749462*^9, 3.641474613421914*^9, 3.64147492400725*^9, 
   3.6414749703449383`*^9, 3.641475235439335*^9, 3.641475771226151*^9, 
   3.641475809742325*^9, 3.6414762597922373`*^9, 3.641476551907352*^9, 
   3.641476913449821*^9, 3.641477022947768*^9, 3.641559235755481*^9, 
   3.6415593493080187`*^9, 3.641560148098908*^9, 3.641560313037236*^9, 
   3.64156052833035*^9, 3.641560685606526*^9, 3.642343925210329*^9, 
   3.683045516707041*^9, 3.683392080912883*^9, 3.68339221430497*^9, 
   3.6833931806916513`*^9, 3.684518431852409*^9, 3.705148500832213*^9, 
   3.7318522207954187`*^9},ExpressionUUID->"2459e1dc-8e69-45b9-abd7-\
be736d13e3c4"]
}, Open  ]],

Cell["", "PageBreak",
 PageBreakBelow->True],

Cell["\<\
Of course, we know the distribution in this case so could show its PDF \
directly.\
\>", "Text",
 CellChangeTimes->{{3.639843845709704*^9, 3.63984388399568*^9}, {
  3.639844076230978*^9, 3.639844076869729*^9}, {3.6415610914652357`*^9, 
  3.6415610938150377`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot4", " ", "=", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{"dist", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "200", ",", "800"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "800"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.006"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotTheme", "\[Rule]", "\"\<Classic\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.639842791706175*^9, 3.6398428499565563`*^9}, {
  3.6398432460405912`*^9, 3.6398433376466093`*^9}, {3.6398438230133467`*^9, 
  3.6398438250834427`*^9}, {3.639936130871251*^9, 
  3.639936133735342*^9}},ExpressionUUID->"f2f36a36-f1b8-4e67-9a4c-\
f3e90f70bdf7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], LineBox[CompressedData["
1:eJwVl3k0VX8XxhGSMmUqRCJDIZSZ890iU2Yqc5RwjRf33HuFKHdq0kSh/EiK
QoZUMhXJWBGiFCVDhJJZife+f531WWetvfbez7Ofs478sQjnE1wcHBw/OTk4
/v9cmCraysFBAO+pW9+1vGaxsl48ZYiHAPjoDrmclFksrM5EqGkjAQqz1BWL
3sxiwylvuJMlCXDZte9Wuukc1mU09Ut6DwFyc1N3LmrOYyVn1Rr1fAhQPpOo
qrRnEQuNngNpfwLYXx3PWY1cxJS9q6tWCQS42Fkfd/7xIvafpm3pK5wA58KP
qrVgS9jF3pBbLhcJ4GJx2IDHYxkL3lkQFVFNgL0nj90XefwXUxKKnnKuJ8DN
LxWyPNwr2OCSYZBuMwHU36B/LS4rmNvrVu9/XQToiSuqaJ9fwSyjf1idnyBA
kUSLE5f5KqZYpyqXJxUMHhDFeYLOgb545bcNUINBjr5+S1T+OrRwJ1HUNCEY
ysT8Y+8NrUObJtw879CDIbc+avWUHDcyjNkwEXg1GDQWB+/sSOdG11OD+X8X
BEMSf3OvbwoPsn2rZr3uSzAoh//zVCpcj46L81w5MRIMpL28t3xm1qOTXv0f
miaCgfmo4tghAz6U/+Ni0IWlYNBlaF+gt/Chdet/McU3h0Cg2n6THbMbUCUq
bVQ+EAIT49Gm30M3oXeMs4LnDoZAkOaDrMHnm9DYG7/Dk04h4N4uKF8hKoAk
vDaPlviEwEcVfQJnrQCKpEbzGFJD4MW7qA7jbUJIpVTH3LYgBJYcKYrC3CLo
+o7KOqJIKJT3p2TYOYghvfCk6gDJUMjWiXvcQBNDH57ZPvXaFgoWVxI5KyvF
kJTTl0Ir1VB48cFBQkFFHGUlcKdtNw2FILM/g/wbJFD+Z/vwDmIolF0X/7d5
WBJZq2whNJJDYYy/y3tEfgv6ET14vDouFBxFJXQsfLcgtY0k93xWKLzpa2c9
HdiCSgzSzROzQ2Fe/0M/+dtW9Oz6kJRmRyjoJ/08580rgzy+FYor9YSCcM2+
r+l2MmhFnSws8zkUVndHOpNTZRD2io+XbywU3k+fVBZT3obqZ9V/f1kLBY/L
c6LczrKo1ZHadGlPGDz4/ODxwPHt6DO/AOlXchhYOj5cf3mbAlp68y6hKSUM
cppu8YUfVECiV66fz8oIAxZm8a0gRgHZSG6/43AvDPRl+TOsexXQM4W9ncU1
YZC8W+Oa7A1FdN3YXZM4GQaFIjTzalUlVLa2zdhqJgysKh47Dnkrobf13yy3
L4XB5cCuo6SrSojHOvRox7pwiOslKfauKCHSoYRkTelwuHx9/lFpjzJyCr87
OW0dDu2E0RWHLFUUqhW81OwQDnL3LF8E9Kki1pwG9+1D4UBE/Xoz4rvQi5MV
0k5+4XDqwneO4ORdSIPZZlNKDYerHrdhmrYbbcr+nR+ZFw79voUSsyx11PjO
5MQMdwTcoxnLf1vSRCYzmzHrjRHQIPft7Q15LVS+eUwiWyQCFpo7mFk2WijH
5WqznWwEiHG6L9/L1ELx70d339eLgLX0vPkcS2207+OlmaPBEUBSGyqsKNiL
cr4OJrxpjwDh561GhU910VbOp26KPRHwbzbY9+KELrosf0Er9nMErFQvPGuX
00Pxx3SHVMYjwHUndS7mrB5SizqgsJ+TCBvFagYj/fQR31w6I1OKCPZx95GH
oiF6vrjfztWOCPXmvw56LZsg4Fe6Zu1IhETyJPeCDoZeyGz4iLkQ4bhNZsLv
KAzVm7b7q7oT4ZbFX12hnxhqOO8Zt+pPBEXZdP7pMYSa5UgF+XFEWBBZvP96
CVCH5d0N/wqIcLN59xm6ihly9GA5zDwkwn/ruoSs7MzQu9CQ1O+lRNB/7a5i
GmWGOq9oyXc+JcLj3uSc3moz1P2pRj/vJREAk7LJcDVHHyN6Ap0+EcGvqIYv
I/kA+nZjfeNd/kgIvHT67xV1KyT8MSqqTyAShhwViuW9rRAmNSArJBIJZxUf
r1+8YIUybpVTqJKRkJ5fYBc9ZYVcbvupHlSMhNxDsRlPSq1Rw4OqC9MmkWDX
KTl21vIgyquJcDGKjISAXiEOl/v2qGe1by2CFAmDBSz3/kF7xA0WhbmUSLh/
7nh0qZQD8q2X4RE8xa4nrmSqd9EBbWlqefL1XCRYleW/6jd0ROc6FKQYuZGQ
PH/TxXOXEwod6v3a0RsJahtj4wN2uiC3ry9SF/oiQei4JHf1ARdk1n/fRmYg
EkJc+p/qBLggqd7Y8sDhSMi+fTI7Nc8FNbfKsVanIyGWekNrvZorUigL3KPG
HwXuP960FBkdQn2Ji/FM4yj4Sut1e48fQVayktLY7SiYF780FuTshaiZ1Pvq
uVFQnXLJopTqhe7L9Olty4sCZcH8HPEsL8Qvnem6UhgFseunJrQmvdBrSYXk
yooo2Jfa0faY6Y2cRPZw6nVEwamL1Y/fvfRBHtyW3/esRcGdaRzV5vmikB/k
R/Le0eDJn9Csdvg4mvf7NjWgQgL34QC10CsE1Bgcztj8nQQ/ruz8byAsAt07
bO+9Mk4CRZ5fKeK0CMTcr7FvdJIEuaIiymYZEchK6ufgsxkSnPh9+tTpxgjU
2hJm4rdKAjGnaCczISJqVwmbKxbHQXk+XMAqgIg+jIYcszPHIWA8Q69RKBJV
dB400LPE4TkxW2enVCRKr90tLG+Dg/cAUTBeMRJ5XJ+omXPAgW+On1vSIBJ9
PhCy9ZYnDgtvSn789otEX3ODO35E4ZA30aiytywSjR8jYKzbOLTiFubHbKMQ
Nf5dbGkuDuk65tZJh6MQb5rBs748HG4Z5Gml+0ahHW827FN/iMPs1izXO6Qo
5KH3QLWzEgc3fY/TGrei0OuNE2Iy3TjUKKS/FBiPQg/LQyeKecnwXCq8wDcm
Ghm3d6t83EAGY22seP50NGodNw7gEiBDhauYSPy5aDQqKzDoKkqGuj26ecdu
RiO5s0U9y3JkuIUxNJnV0eiy9886MwMyHJGo7VJaiUbRvMS03hAynD5+540T
kYQs7jgWt4aTgTzpW5RFJiEp0GqsiSTDhbsXOb/GkdCLmJnZOxQy1KTEDeid
JSHBKZIDMYkMNtfOHzK7TUL5XTG8G26SQS9Yd33dWxKKJXpsW8kkw7msukda
3SRkL2C071c2GexM8f0pH0lo3mLF7/09MpxK/DqqMUxC+ytP1dwuI4O2yzTl
2RIJfc5OIhm2kmHNcSZjmxyOik38z6u/IUOaynr++wo4OtNnnrO9gwy6dXM/
d6rgSFWMt4O3hwxUiRzuOU0ckZms3V2DZKAITLd/NcWRtSJhf+MwGYZLfb0X
D+BIps7a/dl3MkTusjBYs8bRyz/8zKwpMpTZPGn75oQj4fCL30KWyfA0dfzn
ki+OhvjDl31WyBCL3TuT7o+jJ3n2ws5rZFAoi7fcHYQj70EhTJ+HAn2hHW47
InD0wPVqOrcIBYpPaTj5xOEo/ndUyaIoBUo02xVYCThyTHZp+iFBAfNyJ7E7
Z3C02CQ23yFDgXSWv1UhC0fmRjccM1Uo4JlM692YgqNXvBxv23dT4PDmC3WL
13Fk0Rl0kGsPBXTeSCp2puPIimBoEahDAYeqaUfnLBwdvNFvpLWfAuMzx6wT
7+Po9TGLZ8cPUKD1e/X8lwIc2WoU6163ooBt/VMZjYc4sn+VqPXXngJ/HjZ+
SS3DkfOsgvIrTwooBv4NvlaJo67aC7mLPhSwv8SQDqzGkeu5efldxyjgvqP5
sGotjg7LN8lcCqJAzdCNmJg6HPVO7smoC6FAaXVD4PqXOHKrSJOcC6dA9I6R
qaQGHLk7BG92xynw82PGO6smHPVJdV06T6XAViOG3pVmHHmMGgnUxlKAtlHE
orkFR59Kc89Nn6IA6/FPzp+tOPKKF+BTOEOBhQU+ItdrHPVbkemH6BTor01I
5XmDIx+xL1wsFgV0+e9TFtnsW1DybzKZAmMsKiuvHUeD5K2xclcpoP6wt/5E
B46O7T+z5JRKAbNJj3eb37H1FpjAaWkUeGbrX/mQzf4fXWaf3GTP8/cczaAT
RyO51cTx/yjQIHNT9xGbA4g7f0rnUGDgv9Re6S4cjRolh9jfpcCiYEl4NJsD
1y+OJeZT4CXBdV0lm8c6jwY8KqDAgcntmb/YHPRf89DIQwp4DX03E+vG0ThB
y29LGQU0ThavKbM5WCdjwOYxBbKZpR92sXmCY51XfAUFcjw8e9m5gUJfh3ws
rqIAk27HvcquN3Wj+/C3WgpY5XsGvWVz+HGTbrF6dr8GFzYls/mXxj0ny1cU
+OGw5Y8xm4l/BNtjmtn6B4QYfmLP8/sVxbawjQJ3lRV6g9gcdeVry8BbCpio
CfWNsPcx62VtKdJJgW8NmnbObCaplDWYvafAvcpKw4fsfc7NSu0nf6DAKxGR
omX2vvHnSc/zP1Ggq7X54T42L5ybNP40QIHlnDybo2/Z93r4UKXANwoYdt05
H8PWizql9DhqjAJKHLWq8W04Wq64pH13ggIbGRWZAWz9T9KWint/UsDnJ2sY
sf0RJ936wHieAkdUw6TqG3FUmVOi6btEgapXchciX+FoSfXGk6S/7Hrjgaki
bP+R9P3rWzmpcLQ/+z8Ftl/LnttY/eSmglTVryepz3E0baH1VoSPCpSSSzeW
anAUdmj1o5sgFZquHhy+zL6Hws/DR+NEqNAlJxrcWIGjH8fbRrLEqGCPn5mY
fML2Q1Ta71EpKnSLEiUEHrH9eEl7A65Mhecek6ybD3B0S2LrpbRdVNivbxDo
kc/2f+aaWLU6FVr0/Iv57+HoSOHr7ev2UcGF3/kpus3Oi5YA/StABeMzj8z+
se/fdN3NwCJ3dv+jz552sfMk8dzpqQ4vKphpvzlYws6bWpGg6LmjVEj9rbY/
IQZHhtt1EowCqLDIl582F4UjbZP26y1RVPjrRWnCTuBIkbKuceQ8FSzy/xJ8
Ldn3sDp+cMMlKtQRFvRDzHCUTe94p3aVCuL3byQREDs/UzL7o9Oo4KAo1QN6
OBIv1ZvnvEuF3Btr8V5KOOKdCFGUraVCzl2pm25cODo715q0sY4KNpx3rs//
I6FNq6pDSy+psInXuZK1TEKiImO3u1qoYKSrV3VlmoS26/nLnX1PhXk9rnDN
ARIyTPKSmpukwl2qrWzxUxIKl7YTbpWOgcTAz3Eq/iT0W7Ew4qlsDHhrKq0r
8CEhksbG9lz5GFgL/a9zpzv7e2TacjFBOQb+LLRd47YnIVbggY06e2Pgm4vn
pSA9Esp5ZMKbbRMDMy3aax/5SKj3oMYKHhMDs2l+il/vRSM+mnh9TlwMnKiP
PMCTHY30q1eY7QkxkCy9uqCQHo0y1NpEVRkxsDVdLdD+fDTyEQja/flqDPT5
MFfcI6LRyNvbHvsLY+AB19T0Ud1oNOsk/kzwSwzo9g4YvHoRhYTcVvA885NQ
ldQgXtcWiS7N/7Bz4IqF7vRHR+T+RKCygU4XOk8sGJuNDHb/iEA9TZXuVXyx
UF/ym+Pypwgkm3HuhLJQLMQM2PpL1kSgQmxX/Jp0LOzwKUoIS4xAzUxCYbFO
LLg5nNxuyxeBuKTG+IUJsSAcz3E4bFs4wrGRpo72WBBcKlrZ5ReKDg/Z9Cx2
xsLJGc+78q6hSJdVMizbEwvUY3Pt8pahaOldLGfY51iQcMxpxdRDUdyJzUYb
xmNhxXFFaXI5BCVdQA9NueIg+b6GqVRqCLrSl55Sti8O4o5eth3tDEZFZHu/
lPQ4YKrTZP8LJaCuTDVr+q04sPr62fvVMQJabuDXImfFgaYw3655NwI6INrE
4XY3DoacxdzDDxBQfzHKli6NgyOftmY2yhKQwLjml5zmOLBVXC3n7wpCYZ6i
3qWLcTAYpKVTZRqE1OGD29tD8XDus6wSphuIOK5jeatu8fBfOK9ysXog6p7I
ndfwigd+MFVW2RmI4m5EXr10LB7aIorntcQCUetP/teOEfHw8yaTfGcmAAVk
mqAuVjxs2rxh72xJAMr+k7PzQ1U8cP4w3TSpHYBEH4fNDMqfAgvP0w+OWJ9A
plUKP0K+ngLNXf2lTfXHUV2JFaf+zQSIDV+38ZPXMdSdb9z/UzsRtur6ml/r
8kU/TEfG4q4kguBRG4mKLB9UXnLt1eJiIug+OvvDf6cnUr6xXHrN6zT0Clu9
ML55BJk0RrwJrjwN0Rc+RrbYuqL1bRPPNLafgVs6W3YSehwRvoX6Xj3hDKgY
P5l9kHcQXeiv4rD/fAYsHJYJ+s4W6DCV55+HaRK8f2hXxWdhioa/lG3r3p8E
2za8CavcZ4qiLH0xO/Mk+PDvB52iYIouSlQlIMsk+JfwdUyU0xQ1lBO5FO2S
4K2XLO19NSDt35/WT7klgWOtrHGcLiCB4LLNCcQkeGG05FPkz/5/9Dyqcicr
CRLMw/SV0gxRfp/jitHtJHDqYz1oohqii+77O7pzkuAXKdInyd0QHT6yk8p7
Lwmmzqni1tKGaMx5oolQmARveA2qhLIN0CYbSqDmsyRIfuhomvBQH7nqX7pX
05kEc2udkpUDumhE7LniBx4a2C3UsXrO7UWT3aEjh9bT4E1VERGP3ovmUqTu
dfHR4Lf21zBVr72IS5ys3L6RBi+cVOgd6nuRrLj6rkYRGtwWkNKU6tRGh8Vv
7infRoNHh5LSrslqo2ZxiuFlHRroY/Zn+hs1Uft7xb8CejQ4YvnJRaBME/Wk
dlad16dBPIso6JSpiYbFNUyYRjQ4339TQoykiTgkRtApUxpI7Qp3Y+7QRAYS
LgdC7WiwdFjvxF7ePeiBxB5HqxM0GMv45W99Vw1dLpdOrQ2gQf3R2My9p9UQ
2Zmvb18QDfi3jN8w9VZDpsmDx+VDaKB8XTyxWVwNfeBJofwh0kCoTeZTAms3
4p1f+q8wjgZ3OL8yzpB2Ib+u+inhFBqc4Jk2NA9QQRaRxdrMVBqU7BSSPWWh
gtSEblH+XadBwZ4AuY9KKmjJBuf8kU4DVWUfpZnvyii5Xln8ZRYNtHRLvxeF
KKPq0gvGeAENYNzAwCBGCW25fPj8x3oaDO91tOQtVESuB5hJEQ00ML75I/Dr
RUV05c/TWJ5GGlTm7bIciFBE/Ce2hmq1sPuX3f3OfJ8iWjH4bHu2nQYiizVr
z2oV0NchP0GDz2x+hlTU+nagfL2wK2nzNBidDSwL3iWPhiczz2os0oDuq6HC
EJZH8jlvTzcs0QAnin+sW9iOMjZpRk3/pcHTJfu49Jfb0YXBGWcrLjq0xDOe
NfpsR8TzVLElQTrYbz9/kFNXDhl8SbpxRIUO7j35Er6uMijtPTGuU5UOhls6
11R3y6ClNm8/u910oHw32ajEJYOeVOjtNtOgw3/+N3oflUgj7asTtRr76CCy
S5YoLyyNdh1wGeUBOmzJN9oq+2ErkinYoVN+hA6LNxwmQ85LotjbQlJ73OnQ
u5BjsjNIEvXdWFm970GHVFWS6cYDkiiN1tOc5U2HA99yn3itSSAxn3Ne54/T
gZs79bEwWQIJiMwkHYugg/ZBFe20EHG0Sq7rFGbSQUvU1Z6LLIrKaTPBBSw6
mPfGSCYeEkXBVxXWWZyjg9XIbQs1HVHUU0TfG3uRDhfPf+IXmt+MioatU0au
0aGNEn5ribwZeTl3HqrMpsNKU3j7niQRVKk+9OF4JR1O9ZsM5VGEENFILHK1
ig5Iay4l1lQIKVkf2JBeQ4cat9v1WRuF0FX/PIO3L+iw31xuy4dsQUS4GZKh
30QHf9OEE6tvBdCWDXOeAt10kKJ3qncYbELkYe4vT6bowNF2b+tGyw2Iv4P0
1/oXHY4Ebk7bJL0BZVUNS/ZP04Ff+PNLx198qPlqg+O6OTr4NZ3pz0rjQ1Km
tHqHP3RoP95l7PhzParNXHdvjJcBzgb7Mx7d5UW8R7jCpLYz4Ll6aJDffm6U
sT/qbJE8A8bxYW85WW60R+PbXVBggEh4go3En3XIjad+IECJAV2VGkNFZevQ
g0enHR+pMeARzybJOKV1yF6Yc5+tAQNiE/1OH9rChW60rP2Jd2ZAlJuUj4gC
B7Jf2M294MKAkO1Lrn7rORCvgptA+CEGfGvPvfWkdw0jxZXI+bgxwA5r+p4W
vIY57vEzx3wYYOhacNYoZRXjS62/uEpggNhO5f7MhRXspC99e8JpBnxweekv
Mr+MaV0sVV08w4CVg5FCIU3L2Nizfu0IGgMIxPzdmzKWscOiugeOMhmwZL2M
KcAypt04SkAXGeCZGXwl49ISNrHb6tFaGgMSOTQlvY0WMa9FfovEEgbImJz/
W/NyDgs2iuXaUsaATeUUBa2bcxg1YaK2+BEDWp990piImsNS1r/W+/KEPX9/
upW2whzWJnlRFathQJ5LqCAncxYz1BcSWGlhQGCj6B0LzxlsS4xoN2WIAZmX
gh0q9k5jSjVJl4VGGODX/SvbTHQa28c5Z5s3ygDXDUZ/No/+whzPdr/qGWfA
4uPD7xgBvzBmeupTnWl2v3NeR16H/sQWnknenF1hQJYnLXlv8iTW/Uf6WIQE
EwbPb/j0Sm4c40602jgpyYT5mtPb0n6NYTo8eHnQVia4q8pw1T4fw64LveU9
JsME5TCLp1x+Y5ibYmKB6w4mxGtgUsfyvmOf7IbnDDSYsEAt4hAwG8W+ZRcy
uS2YsOxfKdNdNoRtVvqoedqSCRbPPc9pXhjCzAp4+v5ZMaH1Q/HIuxNDWO5j
H7XFg0wwdVgsH9w6hAW0Cr8bd2JCirUp5y76N2x8liTV7s0Et4XBCM6gQWza
wqQoHWdCWc10vnDFALZ2P79PkMKE0T++YgWxA5iggBgfjcoEbZ+tC6VoAFPr
+nEsPJYJ+lL6wVwt/VjQ0bQtZqeZcLISBd38+hkbpMwmTV5gwlJSgrG0wies
M/++B8plAv0IpXZiuhcb3CjOKr/LhEXbDZq9L3qx6fDEx6p5TJj1dlOXvtKL
CeocERZ7wISd9Sz6A+1e7GAdd+NYMRPmZP5O98T0YA0fj2pdrWJCi45G8ITk
e+wxvwTfSCcTdtf4Mx0vdWJS9FdjMd1MKLhcvLYhoBNLXCO1CPYwQSkmckHS
pBOznes6p/+RCatdD2c0Jt9hw/1XBC58YULEbN8xfft3mGipgOjeSSaweE/I
6sp3YNTdNbNNU0zgK6oMHVxuxwbuhnZ7/WLr29QqMFXajj3IaEtlzDDhq4kN
vFRox/bTzm7pW2LCO6OnYnaCb7HIIzyyp3lY8FZXLGv8XxvW8658VXw9C25G
cA4fqG3DjG39vzzgY8HXoK29ygltGJ/py+zujSz4nSTRSeVqw7J3nVZQ2cwC
w7vXavcKtWLt/1ZU2mVZcKA1+40eNGPquXN7t+mzwP5JifC2Pw3Yk6O+nDcM
WGCXlNOZ/boBw6RfvxU2YoGm4RmexKwGzP7qHQI3xoIawVc77C0aMGKic9aE
GQv+FL/SlUx7iZV7lfBXOrBgR5LYv/aD9ZjxFpkPe51YkFW6qaZWoR571cW8
W+TMgovbfBZX/9ZhPTZH4fYhFix57UmMLKrDlvQFySxPFuR6qt0SFKvDjMRD
Bw8HsmCn6MUGly/PsYaO3ocdQSzINBvX6E17jtleMIuzCWaB/O61yxPOzzGv
ddKSWBgLjtzn+lffXIud+t1iuzOaBdFct6SFqmqw+jfKFbOnWHDIwsFd71kV
Zs0YSr58nQXDKlGvF8QqsP02yba6aSx4Uf2P6PfhKWYoaMD/OZ0Fz85IYR63
nmJq15Ppypks0JH2uPB751NM+J5BXO0dFhgMLAlfR0+wD68uESZLWLBS2dXx
5Hw59u6sofLVMhb8E+s/GXOkHGu1GxnWK2eBOZeoQYVCOVb93tA36SkLiGcM
Ku7WPMKyRkYOS9WywNRCJlthsQwL4DE2t2pjQUeGSH5zQil2tGWU8+drFkhP
hXN0OpdibhevPL/2lgUPim+EWyqVYjbi3w2/vGNBXntiR9TbEkx951Ut8gcW
KH569atUoQSbMx+TzR1hgTUmHSpaX4RN8V37bP2dBREFl706SEXY6GuTjF9j
LKDxVRtbqxRhH1yviRtNst+XcOoFXSnEqv2xTZ0zLIDXTRXqoQXYY5XxFsoc
C5JtHpffUizAHk5eY25bYMGFv1fbKvsfYNmkcS7CMgucfFW2rTo9wNL1U14I
/mWBiYal9XaBB9jVFexU+Qp7Pq2t0RPN97FzL8aNPFZZkGIkLe1Dv48l0VKW
19ZYEBzV30Defx/7HxicLxw=
       "]]},
     Annotation[#, "Charting`Private`Tag$5666#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{200, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"PDF\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"Data\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}}, {{{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}, {{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{200, 800}, {0, 0.006}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.639842851279273*^9, 3.639842991257634*^9, 3.639843233680912*^9, {
   3.63984327589475*^9, 3.639843300412938*^9}, 3.6398433399022408`*^9, 
   3.639843894746955*^9, 3.639844743466784*^9, 3.639936039158309*^9, 
   3.639936134802717*^9, 3.6399362014964314`*^9, {3.639936751236203*^9, 
   3.639936774505883*^9}, 3.639937108007102*^9, 3.6404347031475687`*^9, 
   3.6413056329050217`*^9, 3.641306009428668*^9, 3.641306158172792*^9, 
   3.641306298191127*^9, 3.6413071336306133`*^9, 3.641307723941309*^9, 
   3.641307875036498*^9, 3.641308217486743*^9, 3.6413082508662777`*^9, 
   3.641308400265078*^9, 3.6413932582040663`*^9, 3.641393450662814*^9, 
   3.641393652912339*^9, 3.641393694707335*^9, 3.641396405994426*^9, 
   3.6413976302141943`*^9, 3.6414716852142344`*^9, 3.6414719904383173`*^9, 
   3.641472221514948*^9, 3.641472736927162*^9, 3.641474613589945*^9, 
   3.6414749241746683`*^9, 3.641474970738059*^9, 3.6414752355993156`*^9, 
   3.64147577160359*^9, 3.6414758101239967`*^9, 3.6414762599555798`*^9, 
   3.641476552072269*^9, 3.6414769136154757`*^9, 3.6414770231700993`*^9, 
   3.641559235930889*^9, 3.641559349477466*^9, 3.641560148261414*^9, 
   3.641560313202342*^9, 3.641560528504587*^9, 3.641560685771154*^9, 
   3.642343925397356*^9, 3.6830455168838263`*^9, 3.683392081085178*^9, 
   3.683392214455583*^9, 3.683393180853253*^9, 3.684518432033407*^9, 
   3.705148501005712*^9, 
   3.731852221013747*^9},ExpressionUUID->"0f6e0505-0ae6-4a96-8737-\
afe9719d2fd5"]
}, Open  ]],

Cell["However, the histogram then hides the PDF.", "Text",
 CellChangeTimes->{{3.639844084485559*^9, 3.639844102741061*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot5", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"plot4", ",", "hist"}], "}"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "1"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.639843676900179*^9, 3.639843706210841*^9}, {
   3.639843908155011*^9, 3.639843909219521*^9}, {3.63984395617136*^9, 
   3.639843956226177*^9}, {3.639844708110981*^9, 3.6398447114268637`*^9}, 
   3.6413083199936666`*^9, {3.64130836816289*^9, 3.641308386924883*^9}, {
   3.731852172780068*^9, 
   3.731852173267426*^9}},ExpressionUUID->"4f0fc21f-9c43-46cf-aff2-\
7aaaa84cfd0b"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVl3k0VX8XxhGSMmUqRCJDIZSZ890iU2Yqc5RwjRf33HuFKHdq0kSh/EiK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        "]]},
      Annotation[#, "Charting`Private`Tag$5666#1"]& ]}, {}, {}}, {
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.46199999999999997`], Thickness[Small]}], {}, 
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.46199999999999997`], Thickness[Small]}], 
      RectangleBox[{140., 0}, {160., 0.00001},
       RoundingRadius->0], RectangleBox[{180., 0}, {200., 0.00001},
       RoundingRadius->0], RectangleBox[{200., 0}, {220., 0.00005},
       RoundingRadius->0], RectangleBox[{220., 0}, {240., 0.00008},
       RoundingRadius->0], RectangleBox[{240., 0}, {260., 0.00033},
       RoundingRadius->0], RectangleBox[{260., 0}, {280., 0.00054},
       RoundingRadius->0], RectangleBox[{280., 0}, {300., 0.00154},
       RoundingRadius->0], RectangleBox[{300., 0}, {320., 0.0025},
       RoundingRadius->0], RectangleBox[{320., 0}, {340., 0.0033},
       RoundingRadius->0], RectangleBox[{340., 0}, {360., 0.00449},
       RoundingRadius->0], RectangleBox[{360., 0}, {380., 0.00488},
       RoundingRadius->0], RectangleBox[{380., 0}, {400., 0.00526},
       RoundingRadius->0], RectangleBox[{400., 0}, {420., 0.00491},
       RoundingRadius->0], RectangleBox[{420., 0}, {440., 0.0039},
       RoundingRadius->0], RectangleBox[{440., 0}, {460., 0.00311},
       RoundingRadius->0], RectangleBox[{460., 0}, {480., 0.00281},
       RoundingRadius->0], RectangleBox[{480., 0}, {500., 0.00263},
       RoundingRadius->0], RectangleBox[{500., 0}, {520., 0.00216},
       RoundingRadius->0], RectangleBox[{520., 0}, {540., 0.00214},
       RoundingRadius->0], RectangleBox[{540., 0}, {560., 0.00162},
       RoundingRadius->0], RectangleBox[{560., 0}, {580., 0.00129},
       RoundingRadius->0], RectangleBox[{580., 0}, {600., 0.00099},
       RoundingRadius->0], RectangleBox[{600., 0}, {620., 0.00063},
       RoundingRadius->0], RectangleBox[{620., 0}, {640., 0.0004},
       RoundingRadius->0], RectangleBox[{640., 0}, {660., 0.0002},
       RoundingRadius->0], RectangleBox[{660., 0}, {680., 0.00011},
       RoundingRadius->0], RectangleBox[{680., 0}, {700., 0.00005},
       RoundingRadius->0], RectangleBox[{700., 0}, {720., 0.00004},
       RoundingRadius->0], RectangleBox[{720., 0}, {740., 0.00001},
       RoundingRadius->0], RectangleBox[{760., 0}, {780., 0.00001},
       RoundingRadius->
        0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{200, 0},
  AxesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  BaseStyle->Automatic,
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"PDF\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"Data\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[0.2]],
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}}, {{{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}, {{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Automatic,
  ImageMargins->1,
  ImagePadding->All,
  ImageSize->600,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "PointSizeFunction" -> None, "ScalingFunctions" -> 
    None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{200, 800}, {0, 0.006}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.639843911264525*^9, 3.6398439571458673`*^9, 3.639844198291637*^9, {
   3.6398447135308228`*^9, 3.639844743519609*^9}, 3.639936039411375*^9, 
   3.639936142048877*^9, 3.639936201568101*^9, {3.639936751301134*^9, 
   3.639936774558766*^9}, 3.639937108070792*^9, 3.64043470320181*^9, 
   3.6413056329584*^9, 3.641306009483446*^9, 3.64130615823265*^9, 
   3.641306298244766*^9, 3.6413071336856327`*^9, 3.641307723996961*^9, 
   3.6413078750999527`*^9, 3.641308217542688*^9, 3.641308250922039*^9, 
   3.641308400317731*^9, 3.6413932582695208`*^9, 3.64139345071929*^9, 
   3.6413936529773083`*^9, 3.641393694767009*^9, 3.64139640603088*^9, 
   3.64139763027044*^9, 3.641471685277093*^9, 3.641471990494071*^9, 
   3.6414722215695477`*^9, 3.6414727371879597`*^9, 3.641474613645005*^9, 
   3.641474924230611*^9, 3.641474970793227*^9, 3.641475235653449*^9, 
   3.64147577165867*^9, 3.641475810179138*^9, 3.641476260011538*^9, 
   3.641476552128207*^9, 3.641476913670598*^9, 3.6414770232255363`*^9, 
   3.64155923599547*^9, 3.6415593495399027`*^9, 3.6415601483201942`*^9, 
   3.64156031325981*^9, 3.641560528764853*^9, 3.6415606858266068`*^9, 
   3.64234392546074*^9, 3.683045516967235*^9, 3.683392081169654*^9, 
   3.683392214547679*^9, 3.6833931809506397`*^9, 3.6845184321245623`*^9, 
   3.7051485011040277`*^9, 
   3.7318522211113863`*^9},ExpressionUUID->"c0ed2404-5c53-4a16-b85f-\
508a2349db8f"]
}, Open  ]],

Cell["", "PageBreak",
 PageBreakBelow->True],

Cell["\<\
A simple workaround is to reuse fakePlot so that the PDF overlay can be drawn \
last.\
\>", "Text",
 CellChangeTimes->{{3.639844117148631*^9, 3.639844136851935*^9}, {
   3.6398441812826157`*^9, 3.639844214513733*^9}, {3.6398445323845787`*^9, 
   3.639844533591663*^9}, {3.639936221581098*^9, 3.63993622233292*^9}, {
   3.6415606529821672`*^9, 3.641560653276205*^9}, {3.641561187381833*^9, 
   3.641561205499632*^9}, 3.6423442465695667`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot6", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"fakePlot", ",", "hist", ",", "plot4"}], "}"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "1"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.639843676900179*^9, 3.639843706210841*^9}, {
   3.639843908155011*^9, 3.639843909219521*^9}, {3.63984395617136*^9, 
   3.639843956226177*^9}, {3.639844148389064*^9, 3.6398441672701483`*^9}, {
   3.639844201715701*^9, 3.63984420176519*^9}, 3.639936164146394*^9, {
   3.731852183139806*^9, 
   3.731852183667595*^9}},ExpressionUUID->"968a1847-4b8f-4f20-8e0f-\
f42a34e8a38b"],

Cell[BoxData[
 GraphicsBox[{{
    GraphicsComplexBox[{{200.00001224489796`, 0.}, {799.9999877551021, 
     0.}}, {}], {}, {}}, {
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.46199999999999997`], Thickness[Small]}], {}, 
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.46199999999999997`], Thickness[Small]}], 
      RectangleBox[{140., 0}, {160., 0.00001},
       RoundingRadius->0], RectangleBox[{180., 0}, {200., 0.00001},
       RoundingRadius->0], RectangleBox[{200., 0}, {220., 0.00005},
       RoundingRadius->0], RectangleBox[{220., 0}, {240., 0.00008},
       RoundingRadius->0], RectangleBox[{240., 0}, {260., 0.00033},
       RoundingRadius->0], RectangleBox[{260., 0}, {280., 0.00054},
       RoundingRadius->0], RectangleBox[{280., 0}, {300., 0.00154},
       RoundingRadius->0], RectangleBox[{300., 0}, {320., 0.0025},
       RoundingRadius->0], RectangleBox[{320., 0}, {340., 0.0033},
       RoundingRadius->0], RectangleBox[{340., 0}, {360., 0.00449},
       RoundingRadius->0], RectangleBox[{360., 0}, {380., 0.00488},
       RoundingRadius->0], RectangleBox[{380., 0}, {400., 0.00526},
       RoundingRadius->0], RectangleBox[{400., 0}, {420., 0.00491},
       RoundingRadius->0], RectangleBox[{420., 0}, {440., 0.0039},
       RoundingRadius->0], RectangleBox[{440., 0}, {460., 0.00311},
       RoundingRadius->0], RectangleBox[{460., 0}, {480., 0.00281},
       RoundingRadius->0], RectangleBox[{480., 0}, {500., 0.00263},
       RoundingRadius->0], RectangleBox[{500., 0}, {520., 0.00216},
       RoundingRadius->0], RectangleBox[{520., 0}, {540., 0.00214},
       RoundingRadius->0], RectangleBox[{540., 0}, {560., 0.00162},
       RoundingRadius->0], RectangleBox[{560., 0}, {580., 0.00129},
       RoundingRadius->0], RectangleBox[{580., 0}, {600., 0.00099},
       RoundingRadius->0], RectangleBox[{600., 0}, {620., 0.00063},
       RoundingRadius->0], RectangleBox[{620., 0}, {640., 0.0004},
       RoundingRadius->0], RectangleBox[{640., 0}, {660., 0.0002},
       RoundingRadius->0], RectangleBox[{660., 0}, {680., 0.00011},
       RoundingRadius->0], RectangleBox[{680., 0}, {700., 0.00005},
       RoundingRadius->0], RectangleBox[{700., 0}, {720., 0.00004},
       RoundingRadius->0], RectangleBox[{720., 0}, {740., 0.00001},
       RoundingRadius->0], RectangleBox[{760., 0}, {780., 0.00001},
       RoundingRadius->
        0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{{}, \
{}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVl3k0VX8XxhGSMmUqRCJDIZSZ890iU2Yqc5RwjRf33HuFKHdq0kSh/EiK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        "]]},
      Annotation[#, "Charting`Private`Tag$5666#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{200, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"PDF\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"Data\"", FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
       "Bold", StripOnInput -> False], TraditionalForm], None}},
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}, {{0, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.000\"", 0, Editable -> False], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {0.0002, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0004, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {
      0.0006000000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0008, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.001, 
       FormBox[
        TagBox[
         InterpretationBox["\" 0.001\"", 0.001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0012000000000000001`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0014000000000000002`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0016000000000000003`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0018000000000000004`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0020000000000000005`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.002\"", 0.0020000000000000005`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.0022000000000000006`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0024000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0026000000000000007`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.002800000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.003\"", 0.003000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.003200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003400000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.003600000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0038000000000000013`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004000000000000001, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.004\"", 0.004000000000000001, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.004200000000000001, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0044, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0046, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0048, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.004999999999999999, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.005\"", 0.004999999999999999, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}, {
      0.005199999999999999, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0053999999999999986`, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005599999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.005799999999999998, 
       FormBox["\"\"", TraditionalForm], {0, 0.005}}, {0.0059999999999999975`, 
       FormBox[
        TagBox[
         InterpretationBox[
         "\" 0.006\"", 0.0059999999999999975`, AutoDelete -> True], 
         PaddedForm[#, {4, 3}]& ], TraditionalForm], {0, 0.01}}}}, {{{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}, {{200, 
       FormBox["200", TraditionalForm], {0, 0.014097744360902257`}}, {220., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {240., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {260., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {280., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {300., 
       FormBox["300", TraditionalForm], {0, 0.014097744360902257`}}, {320., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {340., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {360., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {380., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {400., 
       FormBox["400", TraditionalForm], {0, 0.014097744360902257`}}, {420., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {440., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {460., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {480., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {500., 
       FormBox["500", TraditionalForm], {0, 0.014097744360902257`}}, {520., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {540., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {560., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {580., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {600., 
       FormBox["600", TraditionalForm], {0, 0.014097744360902257`}}, {620., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {640., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {660., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {680., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {700., 
       FormBox["700", TraditionalForm], {0, 0.014097744360902257`}}, {720., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {740., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {760., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {780., 
       FormBox["\"\"", TraditionalForm], {0, 0.007048872180451128}}, {800., 
       FormBox["800", TraditionalForm], {0, 0.014097744360902257`}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->1,
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{200, 800}, {0, 0.006}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.639844157660647*^9, 3.639844168604837*^9}, 
   3.639844202514801*^9, 3.639844743570467*^9, 3.639936039462508*^9, {
   3.63993615219531*^9, 3.6399361657007732`*^9}, 3.639936201632022*^9, {
   3.639936751355919*^9, 3.639936774611072*^9}, 3.6399371081335983`*^9, 
   3.640434703257126*^9, 3.6413056330120687`*^9, 3.641306009536953*^9, 
   3.64130615828679*^9, 3.6413062983106337`*^9, 3.6413071337394657`*^9, 
   3.6413077240515013`*^9, 3.6413078751627607`*^9, 3.641308217599229*^9, 
   3.641308250975642*^9, 3.64130840039898*^9, 3.641393258335123*^9, 
   3.6413934507746267`*^9, 3.641393653043343*^9, 3.6413936948635187`*^9, 
   3.641396406059123*^9, 3.641397630324469*^9, 3.641471685337874*^9, 
   3.641471990548967*^9, 3.641472221623879*^9, 3.6414727372419453`*^9, 
   3.641474613700006*^9, 3.6414749242860394`*^9, 3.641474970848472*^9, 
   3.6414752357085*^9, 3.6414757717142887`*^9, 3.6414758102339153`*^9, 
   3.641476260066649*^9, 3.641476552184547*^9, 3.641476913725278*^9, 
   3.64147702328001*^9, 3.641559236058323*^9, 3.641559349603045*^9, 
   3.6415601483733892`*^9, 3.641560313314435*^9, 3.6415605288184643`*^9, 
   3.641560685879904*^9, 3.642343925523911*^9, 3.6830455170513277`*^9, 
   3.6833920812533216`*^9, 3.683392214634747*^9, 3.683393181046307*^9, 
   3.684518432216845*^9, 3.7051485011901484`*^9, 
   3.731852221207395*^9},ExpressionUUID->"46cfe575-69a0-4fc7-ae44-\
7ba32c2117b0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<histPlot.png\>\"", ",", "plot6"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
  3.63984107879326*^9, 3.6398411135145807`*^9}, {3.64043464444601*^9, 
  3.640434661985324*^9}, {3.6415601321889753`*^9, 3.6415601336122303`*^9}, {
  3.683045499410116*^9, 3.683045500681052*^9}, {3.731852198612659*^9, 
  3.7318521992428007`*^9}},ExpressionUUID->"e98ffc50-1bf6-4457-b204-\
998357db70c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<histPlot.pdf\>\"", ",", "plot6"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.632742680536683*^9, 3.6327427293423777`*^9}, {
  3.63984107879326*^9, 3.6398411135145807`*^9}, {3.64043464444601*^9, 
  3.640434661985324*^9}, {3.6415601321889753`*^9, 3.6415601336122303`*^9}, {
  3.683045499410116*^9, 
  3.683045500681052*^9}},ExpressionUUID->"d8db972a-2c86-4201-8ed4-\
238a2b73f990"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1038, 1255},
WindowMargins->{{13, Automatic}, {Automatic, 15}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3209, 49, 211, "Title",ExpressionUUID->"0b11af89-d3bd-40b7-94f7-5cecafdab4c0"],
Cell[CellGroupData[{
Cell[3814, 75, 146, 2, 84, "Section",ExpressionUUID->"01ea108b-494a-4d13-b47c-c66b615f1221"],
Cell[3963, 79, 3599, 61, 336, "Text",ExpressionUUID->"969219f9-5275-4a3b-917f-a966d7b45a2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7599, 145, 153, 2, 84, "Section",ExpressionUUID->"97f424ec-8bc4-433e-89c8-5bb9bbc0fab0"],
Cell[7755, 149, 1408, 25, 510, "Text",ExpressionUUID->"1ed03231-8008-47a0-8ed6-c751c015bf8b"],
Cell[9166, 176, 44, 1, 1, "PageBreak",ExpressionUUID->"4997e748-96a4-4cdc-9658-05b943682e49",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[9247, 182, 207, 3, 84, "Section",ExpressionUUID->"0e6d1f74-1f10-44dd-9fcc-939e0e592f51"],
Cell[9457, 187, 131, 2, 44, "Text",ExpressionUUID->"80b45546-e35b-40ec-963f-2c3ba179084a"],
Cell[9591, 191, 1185, 22, 37, "Input",ExpressionUUID->"d6a84bf2-782c-4ec9-861b-58b6d5e2c5a1"],
Cell[10779, 215, 338, 9, 37, "Input",ExpressionUUID->"c5feabd4-5ba0-4e12-bd20-4a53de61c613"],
Cell[11120, 226, 373, 8, 73, "Text",ExpressionUUID->"7e968f37-5d46-4c28-a2a4-d657b48913f9"],
Cell[CellGroupData[{
Cell[11518, 238, 391, 10, 37, "Input",ExpressionUUID->"d154abff-d074-4dbb-8d86-3926c7a8343e"],
Cell[11912, 250, 14578, 256, 304, "Output",ExpressionUUID->"598f6a00-497b-4032-bce8-a6468b692d3f"]
}, Open  ]],
Cell[26505, 509, 2484, 41, 64, "Input",ExpressionUUID->"fea26e8e-96c2-4af4-b718-a515b604a8f2"],
Cell[28992, 552, 320, 7, 44, "Text",ExpressionUUID->"fe8f0997-24f0-4423-904f-7b129cb9edd7"],
Cell[CellGroupData[{
Cell[29337, 563, 1031, 24, 64, "Input",ExpressionUUID->"f4bfa27e-5112-4008-a227-01d60b38771d"],
Cell[30371, 589, 22307, 397, 310, "Output",ExpressionUUID->"2d4853e6-1520-4596-9578-2931d22d8e42"]
}, Open  ]],
Cell[52693, 989, 44, 1, 1, "PageBreak",ExpressionUUID->"ddd24eba-6155-4e15-bd7b-b05c8d9dbb12",
 PageBreakBelow->True],
Cell[52740, 992, 344, 7, 73, "Text",ExpressionUUID->"c7a0bd86-8744-44d5-8d3a-28a41d3d7261"],
Cell[CellGroupData[{
Cell[53109, 1003, 1104, 25, 64, "Input",ExpressionUUID->"195f31c6-e896-45f9-9ecc-6d5bda8b9685"],
Cell[54216, 1030, 22286, 398, 505, "Output",ExpressionUUID->"35dca69f-2b8f-4894-9165-2edfbd9b81f2"]
}, Open  ]],
Cell[76517, 1431, 249, 6, 37, "Input",ExpressionUUID->"134fd2fb-8ba4-4e1a-b415-e8971692fe3c"],
Cell[76769, 1439, 494, 9, 37, "Input",ExpressionUUID->"873ee5e9-2aa4-4b73-b0a8-ddfa6c71cc7a"],
Cell[77266, 1450, 449, 9, 37, "Input",ExpressionUUID->"cd33bb7e-665b-4f1c-a924-493139e9d529"],
Cell[77718, 1461, 505, 8, 73, "Text",ExpressionUUID->"b8c4d3bf-6cc4-4789-a102-d2be8e149468"],
Cell[CellGroupData[{
Cell[78248, 1473, 1336, 30, 90, "Input",ExpressionUUID->"9eee9bae-41aa-4ddc-bbd1-3e0e810fb2fd"],
Cell[79587, 1505, 22061, 396, 350, "Output",ExpressionUUID->"5c3e8661-c536-4bff-a1e0-e6bda55a5d23"]
}, Open  ]],
Cell[101663, 1904, 394, 8, 44, "Text",ExpressionUUID->"817b91f0-9a37-43c2-bd27-12742f06cf6a"],
Cell[102060, 1914, 400, 8, 37, "Input",ExpressionUUID->"a493874e-7df2-44ee-b9cc-777141436b75"],
Cell[102463, 1924, 44, 1, 1, "PageBreak",ExpressionUUID->"9bd0489c-78f3-4b6b-a25e-09395a73887a",
 PageBreakBelow->True],
Cell[102510, 1927, 179, 4, 44, "Text",ExpressionUUID->"8abdac1c-f627-406c-a798-5b43fb15bb1c"],
Cell[CellGroupData[{
Cell[102714, 1935, 1152, 30, 90, "Input",ExpressionUUID->"11ec2f85-b407-416d-9cce-060231cd8269"],
Cell[103869, 1967, 21235, 382, 315, "Output",ExpressionUUID->"8131f0f4-0e36-4c0c-bd29-ef3bb129051e"]
}, Open  ]],
Cell[125119, 2352, 350, 8, 73, "Text",ExpressionUUID->"c406f57a-399a-4c19-8bd0-b9f59ef92b13"],
Cell[125472, 2362, 203, 5, 37, "Input",ExpressionUUID->"447a95c4-14ed-4003-8df2-fbbf5abcc584"],
Cell[CellGroupData[{
Cell[125700, 2371, 402, 10, 37, "Input",ExpressionUUID->"7d50f42f-8ce6-44c8-b747-3dea1f8bc5a1"],
Cell[126105, 2383, 21154, 385, 302, "Output",ExpressionUUID->"8279ba39-a335-46d5-98d5-b4398ffd4497"]
}, Open  ]],
Cell[147274, 2771, 44, 1, 1, "PageBreak",ExpressionUUID->"8581ee0c-9cfa-493f-930a-040e6cc967ba",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[147355, 2777, 310, 4, 84, "Section",ExpressionUUID->"a7df2307-365d-4498-a63f-c09840aa6cea"],
Cell[147668, 2783, 202, 5, 44, "Text",ExpressionUUID->"1405e109-c84e-49bb-8c59-d7854d62b54f"],
Cell[CellGroupData[{
Cell[147895, 2792, 719, 19, 37, "Input",ExpressionUUID->"4d320855-6247-4f52-a271-c30b6b84802a"],
Cell[148617, 2813, 18927, 374, 323, "Output",ExpressionUUID->"294f9932-7f43-4c21-a795-dadf22116a8c"]
}, Open  ]],
Cell[167559, 3190, 2505, 40, 64, "Input",ExpressionUUID->"bc50a626-c38d-45f9-837e-62b5719b8355"],
Cell[CellGroupData[{
Cell[170089, 3234, 1106, 25, 64, "Input",ExpressionUUID->"772f115b-2df2-4f48-b794-1401172700ba"],
Cell[171198, 3261, 13034, 310, 311, "Output",ExpressionUUID->"310da267-3da5-4d87-af1f-fc21acbd4462"]
}, Open  ]],
Cell[184247, 3574, 44, 1, 4, "PageBreak",ExpressionUUID->"c8fc1160-3d48-4d3d-a7b1-29ba459c7e0b",
 PageBreakBelow->True],
Cell[184294, 3577, 111, 1, 44, "Text",ExpressionUUID->"dd3dc377-03ea-4f97-9bba-ccfb329e35cc"],
Cell[CellGroupData[{
Cell[184430, 3582, 561, 15, 41, "Input",ExpressionUUID->"52db6c0c-2ff4-4865-9209-8014a8e30ec9"],
Cell[184994, 3599, 2237, 55, 129, "Output",ExpressionUUID->"485c5555-2d5f-44f1-9137-8e9bbd5a80d2"]
}, Open  ]],
Cell[187246, 3657, 2639, 41, 64, "Input",ExpressionUUID->"0535e9b0-6476-48c3-ba5e-27d0ecdc8ba8"],
Cell[CellGroupData[{
Cell[189910, 3702, 1741, 39, 128, "Input",ExpressionUUID->"33fa3f94-2e7f-44c4-b227-7d24df0cf8ec"],
Cell[191654, 3743, 11054, 272, 491, "Output",ExpressionUUID->"abfb8bc4-7baf-4b24-aa47-ed006a2c62e8"]
}, Open  ]],
Cell[202723, 4018, 529, 10, 37, "Input",ExpressionUUID->"192798f5-8eaa-4c2d-b5dc-20824d92428a"],
Cell[203255, 4030, 480, 9, 37, "Input",ExpressionUUID->"3c181a37-a64d-4a0e-8c61-0544cfb81ee9"],
Cell[203738, 4041, 44, 1, 4, "PageBreak",ExpressionUUID->"575f1436-3eaa-4865-9f2d-cb9cef5c0f64",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[203819, 4047, 288, 4, 84, "Section",ExpressionUUID->"f6a09aa7-1140-45cf-82c5-b74f3b6b4418"],
Cell[204110, 4053, 105, 1, 44, "Text",ExpressionUUID->"5af86bde-28a4-40e9-b3ce-9a34832ab409"],
Cell[204218, 4056, 607, 17, 64, "Input",ExpressionUUID->"cb38abb3-010b-4850-b16b-d4b25bfb78df"],
Cell[204828, 4075, 278, 7, 37, "Input",ExpressionUUID->"d677fa83-620e-402f-a6aa-2b4f51b4fa47"],
Cell[205109, 4084, 192, 4, 44, "Text",ExpressionUUID->"5b63f350-e9d4-40d5-9f59-6fa9669896db"],
Cell[CellGroupData[{
Cell[205326, 4092, 648, 11, 37, "Input",ExpressionUUID->"8db2345e-a084-42d5-adfd-06502a69d646"],
Cell[205977, 4105, 4420, 76, 292, "Output",ExpressionUUID->"a228ae29-3c08-40b3-8ed0-8f39a9dafa37"]
}, Open  ]],
Cell[210412, 4184, 2537, 43, 64, "Input",ExpressionUUID->"60aa59c8-d987-47d8-8c57-023b1b3c7bf2"],
Cell[212952, 4229, 363, 6, 44, "Text",ExpressionUUID->"aca39916-6a85-406e-8c3b-3389f6e308fd"],
Cell[213318, 4237, 638, 19, 37, "Input",ExpressionUUID->"5bced2ca-796e-4d92-9949-23cb6bb976b7"],
Cell[213959, 4258, 160, 3, 44, "Text",ExpressionUUID->"132b54a7-0ccf-41f7-b66e-eed24d369740"],
Cell[CellGroupData[{
Cell[214144, 4265, 269, 7, 37, "Input",ExpressionUUID->"f421bb19-24bd-4126-87d4-d67584b1eb20"],
Cell[214416, 4274, 16617, 286, 304, "Output",ExpressionUUID->"2459e1dc-8e69-45b9-abd7-be736d13e3c4"]
}, Open  ]],
Cell[231048, 4563, 44, 1, 4, "PageBreak",ExpressionUUID->"0d3d40ee-cf76-4405-a106-7f28bd59dc42",
 PageBreakBelow->True],
Cell[231095, 4566, 273, 6, 44, "Text",ExpressionUUID->"810bca14-88e3-45e1-b5f0-206f8bcd35ad"],
Cell[CellGroupData[{
Cell[231393, 4576, 811, 20, 64, "Input",ExpressionUUID->"f2f36a36-f1b8-4e67-9a4c-f3e90f70bdf7"],
Cell[232207, 4598, 24900, 431, 305, "Output",ExpressionUUID->"0f6e0505-0ae6-4a96-8737-afe9719d2fd5"]
}, Open  ]],
Cell[257122, 5032, 124, 1, 44, "Text",ExpressionUUID->"54a30f95-0e3c-4b25-80d4-88e0798b699b"],
Cell[CellGroupData[{
Cell[257271, 5037, 656, 14, 37, "Input",ExpressionUUID->"4f0fc21f-9c43-46cf-aff2-7aaaa84cfd0b"],
Cell[257930, 5053, 27333, 470, 493, "Output",ExpressionUUID->"c0ed2404-5c53-4a16-b85f-508a2349db8f"]
}, Open  ]],
Cell[285278, 5526, 44, 1, 4, "PageBreak",ExpressionUUID->"fea309cb-325b-40eb-b6b8-087ec2298a7c",
 PageBreakBelow->True],
Cell[285325, 5529, 450, 8, 44, "Text",ExpressionUUID->"6b7f335d-c649-4f54-890d-c462c4d0ce16"],
Cell[CellGroupData[{
Cell[285800, 5541, 671, 14, 37, "Input",ExpressionUUID->"968a1847-4b8f-4f20-8e0f-f42a34e8a38b"],
Cell[286474, 5557, 27228, 464, 492, "Output",ExpressionUUID->"46cfe575-69a0-4fc7-ae44-7ba32c2117b0"]
}, Open  ]],
Cell[313717, 6024, 497, 9, 37, "Input",ExpressionUUID->"e98ffc50-1bf6-4457-b204-998357db70c3"],
Cell[314217, 6035, 449, 9, 37, "Input",ExpressionUUID->"d8db972a-2c86-4201-8ed4-238a2b73f990"]
}, Open  ]]
}, Open  ]]
}
]
*)

