(* ::Package:: *)

(* ::Input:: *)
(*(* :Title: SetAxes.m -- A package for traditional formatting of axes for 2-D plots. *)*)


(* ::Input:: *)
(*(* :Author: Michael P. McLaughlin *)*)


(* ::Input:: *)
(*(* :Copyright: \[Copyright] 2015 by Michael P. McLaughlin *)*)


(* ::Input:: *)
(*(* :Package version: 1.0 *)*)


BeginPackage["setAxes`"]


setLinAxis::usage = "setLinAxis[isAbscissa,label,LB,UB,majorTicks,minorTicks,pad] reformats a linear axis for basic 2-D plots and their List analogues as described in SetAxesExamples.nb."


setLogAxis::usage ="setLogAxis[isAbscissa,label,log10LB,log10UB,minorTicks] reformats a log axis for basic 2-D plots and their List analogues as described in SetAxesExamples.nb."


defaultAxes::usage = "Restore default formatting for both axes."


Begin["`Private`"]


gFac=375.0/266; SAgrafTicks = {{},{}}; SAlabels={{},{}};


Relabel:=SetOptions[{Plot, DiscretePlot,LogPlot,LogLinearPlot, LogLogPlot,ListPlot,ListLogPlot,ListLogLinearPlot,ListLogLogPlot},
Axes->None,
Frame->{{True,False},{True,False}},
FrameTicks->SAgrafTicks,
PlotRangePadding->{0,0},
BaseStyle->{FontFamily->"Helvetica",FontSize->10},PlotStyle->Black,
FrameLabel->{
Style[SAlabels[[1]],FontFamily->"Helvetica",FontSize->12,FontWeight->"Bold"],Style[SAlabels[[2]],FontFamily->"Helvetica",FontSize->12,FontWeight->"Bold"]
}
]



makeTick[axis_,val_, pad_,isMajorTick_] :=
Module[{s},
If[isMajorTick ,
{If[pad[[2]]== 0,s= Round[val],s=PaddedForm[\!\(\*
TagBox["val",
PaddedForm[#, {3, 2}]& ]\),pad]];
AppendTo[SAgrafTicks[[axis]],{val,Chop[s],{0,If[axis ==2,0.01,0.01*gFac] }}]
},
AppendTo[SAgrafTicks[[axis]],{val,"",{0, If[axis ==2,0.005,0.005*gFac]}}]
]
]



setLinAxis[isAbscissa_,label_,LB_,UB_,majorTicks_,minorTicks_,pad_] := 
Module[{gi,gj,NTicks,gCoord,gInc,axis},
If[isAbscissa,
axis=1;SAgrafTicks[[1]]={};SAlabels[[1]]=label,
axis=2;SAgrafTicks[[2]]={};SAlabels[[2]]= label
];
NTicks = (majorTicks - 1.0)*(minorTicks + 1.0); (* plus origin *)
gCoord = LB;gInc = (UB - LB)/NTicks;
makeTick[axis,gCoord,pad, True];
gCoord+=gInc;
For[gi=1,gi<majorTicks,gi++,
For[gj=1,gj<=minorTicks,gj++,
makeTick[axis,gCoord,pad, False];
gCoord+=gInc
];
makeTick[axis,gCoord,pad, True];
gCoord+=gInc
];
Relabel;
] /; BooleanQ[isAbscissa] && StringQ[label] && NumericQ[LB] && NumericQ[UB] && (UB > LB) && IntegerQ[majorTicks] && (majorTicks >= 2) && IntegerQ[minorTicks] && (minorTicks >= 0) && ListQ[pad] && (Length[pad] === 2) && IntegerQ[pad[[1]]] && IntegerQ[pad[[2]]] && (pad[[1]] >= pad[[2]])


fmt[val_]:=Module[{z,zz},
z = Round[Log10[val]];
If[Abs[z]>5,zz= Superscript[10,z],If[z>=0,zz=Round[val],zz = N[Chop[val]]]];
zz
]


setLogAxis[isAbscissa_,label_,log10LB_,log10UB_,minorT_] := 
Module[{gi,gj,majorTicks,gCoord,factor = 1,axis, fac},
If[isAbscissa,
axis=1;SAgrafTicks[[1]]={};SAlabels[[1]]=label,
axis=2;SAgrafTicks[[2]]={};SAlabels[[2]]= label
];
If[minorT==4,factor=2,If[minorT==8,factor=3]];
majorTicks = log10UB - log10LB + 1;
gCoord = 10^log10LB;
AppendTo[SAgrafTicks[[axis]],{gCoord,fmt[gCoord],{0,If[axis ==2,0.01,0.01*gFac] }}];
fac = {{5},{2,4,6,8},{2,3,4,5,6,7,8,9}};
For[gi = 1, gi <= majorTicks, gi++,
     If [minorT > 0,
         For[gj = 1, gj <= minorT, gj++,
             If[minorT != 8 || gj != 4,
                AppendTo[SAgrafTicks[[axis]], {gCoord fac[[factor]][[gj]],"", {0, If[axis == 2, 0.005, 0.005*gFac]}}],
                AppendTo[SAgrafTicks[[axis]], {gCoord fac[[factor]][[gj]],"", {0, If[axis == 2, 0.006, 0.006*gFac]}}]
                ];
             ];
         ];
     AppendTo[SAgrafTicks[[axis]], {gCoord, fmt[gCoord], {0, If[axis == 2, 0.01, 0.01*gFac] }}];
     gCoord *= 10
];
Relabel;
] /; BooleanQ[isAbscissa] && StringQ[label] && IntegerQ[log10LB] && IntegerQ[log10UB] && (log10UB > log10LB) && (minorT === 0 || minorT === 1|| minorT === 4 || minorT === 8)


defaultAxes:={SetOptions[{Plot, DiscretePlot,LogPlot,LogLinearPlot, LogLogPlot,
ListPlot, ListLogPlot, ListLogLinearPlot, ListLogLogPlot},
Axes->True,
Frame->False,
PlotRangePadding->Automatic,
BaseStyle->Automatic
];
}



End[]


Protect[setLinAxis,setLogAxis,defaultAxes]


EndPackage[]
